/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.geo.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.SimpleContentGenerator;

public class GeoMapExportContentGenerator
extends SimpleContentGenerator
implements Serializable {
    private static final long serialVersionUID = 9199270532521760867L;
    private static final Log C = LogFactory.getLog(GeoMapExportContentGenerator.class);
    private static final String aa = "image/png";

    public void createContent(OutputStream outputStream) throws Exception {
        IParameterProvider iParameterProvider = (IParameterProvider)this.parameterProviders.get("request");
        String string = iParameterProvider.getStringParameter("json", null);
        String string2 = iParameterProvider.getStringParameter("jsonConfig", null);
        String string3 = iParameterProvider.getStringParameter("chartHeight", "400");
        String string4 = iParameterProvider.getStringParameter("chartWidth", "800");
        if (string == null) {
            return;
        }
        String string5 = UUID.randomUUID().toString();
        File file = PentahoSystem.getApplicationContext().createTempFile(this.userSession, string5, ".json", false);
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string);
        fileWriter.flush();
        fileWriter.close();
        File file2 = this.generatePng(file, string2, string3, string4);
        byte[] byArray = IOUtils.toByteArray((InputStream)new FileInputStream(file2));
        outputStream.write(byArray);
        outputStream.flush();
        file.delete();
        file2.delete();
    }

    protected File generatePng(File jsonFile, String jsonConfig, String height, String width) {
        String string = UUID.randomUUID().toString();
        File file = null;
        try {
            file = PentahoSystem.getApplicationContext().createTempFile(this.userSession, string, ".png", false);
        }
        catch (IOException iOException) {
            C.error((Object)"Could not create temp file for map pdf export", (Throwable)iOException);
        }
        String string2 = this.getUrl(jsonFile, jsonConfig, height, width);
        String string3 = PentahoSystem.getSystemSetting((String)"html-to-image-tool", (String)"wkhtmltoimage");
        String string4 = PentahoSystem.getSystemSetting((String)"pentaho-geo/settings.xml", (String)"map-export-javascript-delay", (String)"1000");
        ProcessBuilder processBuilder = this.getProcessBuilder(string3, width, string4, string2, file);
        try {
            Process process = processBuilder.start();
            ____ ____2 = new ____(process.getErrorStream(), "ERROR_STREAM");
            ____ ____3 = new ____(process.getErrorStream(), "OUTPUT_STREAM");
            ____2.start();
            ____3.start();
            process.waitFor();
            return file;
        }
        catch (Exception exception) {
            String string5 = "Error calling HTML to image conversion process [" + string3 + "]";
            C.error((Object)string5, (Throwable)exception);
            throw new RuntimeException(string5, exception);
        }
    }

    protected ProcessBuilder getProcessBuilder(String htmlToImageConverterProcess, String width, String delay, String url, File chartFile) {
        ProcessBuilder processBuilder = new ProcessBuilder(htmlToImageConverterProcess, "-f", "png", "--width", width, "--javascript-delay", delay, url, chartFile.getAbsolutePath());
        return processBuilder;
    }

    protected String getUrl(File jsonFile, String jsonConfig, String height, String width) {
        String string = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
        String string2 = string + "content/geoprint?_TRUST_USER_=" + this.encodeUrl(this.userSession.getName()) + "&jsonDataFile=" + this.encodeUrl(jsonFile.getAbsolutePath()) + (jsonConfig == null ? "" : "&jsonConfig=" + this.encodeUrl(jsonConfig)) + "&height=" + height + "&width=" + width;
        return string2;
    }

    public String getMimeType() {
        return aa;
    }

    public Log getLogger() {
        return C;
    }

    private String encodeUrl(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            C.warn((Object)unsupportedEncodingException.getLocalizedMessage(), (Throwable)unsupportedEncodingException);
            return s;
        }
    }

    class ____
    extends Thread {
        InputStream ab;
        String type;

        ____(InputStream inputStream, String string) {
            this.ab = inputStream;
            this.type = string;
        }

        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.ab);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if (!C.isDebugEnabled()) continue;
                    C.debug((Object)(this.type + " --> " + string));
                }
            }
            catch (IOException iOException) {
                C.error((Object)iOException);
            }
        }
    }
}

