/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.engine;

import java.io.PrintWriter;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.pentaho.actionsequence.dom.IActionControlStatement;
import org.pentaho.actionsequence.dom.IActionDefinition;
import org.pentaho.actionsequence.dom.IActionIfStatement;
import org.pentaho.actionsequence.dom.IActionLoop;
import org.pentaho.actionsequence.dom.IActionSequenceExecutableStatement;

public class ActionSequenceException
extends Exception {
    Date date = new Date();
    String stepDescription;
    String actionSequenceName;
    Integer stepNumber;
    String actionClass;
    String instanceId;
    String sessionId;
    Integer loopIndex;
    IActionDefinition actionDefinition;

    public ActionSequenceException() {
    }

    public ActionSequenceException(String msg) {
        super(msg);
    }

    public ActionSequenceException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public ActionSequenceException(Throwable cause) {
        super(cause);
    }

    public ActionSequenceException(String msg, Throwable cause, String sessionName, String instanceId, String actionSequenceName, String actionDescription, String componentName) {
        this(msg, cause);
        this.setActionSequenceName(actionSequenceName);
        this.setInstanceId(instanceId);
        this.setSessionId(sessionName);
        this.setStepDescription(actionDescription);
        this.setActionClass(componentName);
    }

    public ActionSequenceException(String msg, Throwable cause, String sessionName, String instanceId, String actionSequenceName, IActionDefinition actionDefinition) {
        this(msg, cause);
        this.setActionSequenceName(actionSequenceName);
        this.setInstanceId(instanceId);
        this.setSessionId(sessionName);
        this.setActionDefinition(actionDefinition);
    }

    public ActionSequenceException(String msg, String sessionName, String instanceId, String actionSequenceName, IActionDefinition actionDefinition) {
        this(msg);
        this.setActionSequenceName(actionSequenceName);
        this.setInstanceId(instanceId);
        this.setSessionId(sessionName);
        this.setActionDefinition(actionDefinition);
    }

    public String getStepDescription() {
        return this.stepDescription;
    }

    public void setStepDescription(String description) {
        this.stepDescription = description;
    }

    public String getActionSequenceName() {
        return this.actionSequenceName;
    }

    public void setActionSequenceName(String actionSequenceName) {
        this.actionSequenceName = actionSequenceName;
    }

    public Integer getStepNumber() {
        return this.stepNumber;
    }

    public void setStepNumber(Integer stepNumber) {
        this.stepNumber = stepNumber;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getActionClass() {
        return this.actionClass;
    }

    public void setActionClass(String actionClass) {
        this.actionClass = actionClass;
    }

    public Date getDate() {
        return this.date;
    }

    public IActionDefinition getActionDefinition() {
        return this.actionDefinition;
    }

    public void setActionDefinition(IActionDefinition actionDefinition) {
        this.actionDefinition = actionDefinition;
        this.actionDefinition = actionDefinition;
        if (actionDefinition != null) {
            this.setStepDescription(actionDefinition.getDescription());
            this.setActionClass(actionDefinition.getComponentName());
        }
    }

    public Integer getLoopIndex() {
        return this.loopIndex;
    }

    public void setLoopIndex(Integer loopIndex) {
        this.loopIndex = loopIndex;
    }

    public void printActionExecutionStack(PrintWriter s) {
        if (this.actionDefinition != null) {
            this._printStack((IActionSequenceExecutableStatement)this.actionDefinition, s, "");
        }
    }

    protected void _printStack(IActionSequenceExecutableStatement statement, PrintWriter s, String prefix) {
        if (statement instanceof IActionIfStatement) {
            s.println(prefix + "IF STATEMENT: " + ((IActionIfStatement)statement).getCondition());
        } else if (statement instanceof IActionLoop) {
            s.println(prefix + "LOOP ON: " + ((IActionLoop)statement).getLoopOn());
        } else if (statement instanceof IActionDefinition) {
            String actionDesc = StringUtils.defaultString((String)((IActionDefinition)statement).getDescription(), (String)"");
            s.println(prefix + "EXECUTING ACTION: " + actionDesc + " (" + ((IActionDefinition)statement).getComponentName() + ")");
        } else if (statement instanceof IActionControlStatement) {
            s.println(prefix + "UNKNOWN CONTROL STATEMENT");
        } else if (statement instanceof IActionControlStatement) {
            s.println(prefix + "UNKNOWN CONTROL STATEMENT");
        } else {
            s.println(prefix + "UNKNOWN EXECUTABLE STATEMENT");
        }
        IActionControlStatement parent = statement.getParent();
        if (parent != null) {
            this._printStack((IActionSequenceExecutableStatement)statement.getParent(), s, "\tin ");
        }
    }
}

