/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.AccessController;
import org.owasp.esapi.Authenticator;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.Encryptor;
import org.owasp.esapi.Executor;
import org.owasp.esapi.HTTPUtilities;
import org.owasp.esapi.IntrusionDetector;
import org.owasp.esapi.LogFactory;
import org.owasp.esapi.Logger;
import org.owasp.esapi.Randomizer;
import org.owasp.esapi.SecurityConfiguration;
import org.owasp.esapi.Validator;
import org.owasp.esapi.util.ObjFactory;

public final class ESAPI {
    private static final Object accessorLock = new Object();
    private static Authenticator authenticator = null;
    private static Encoder encoder = null;
    private static LogFactory logFactory = null;
    private static AccessController accessController = null;
    private static IntrusionDetector intrusionDetector = null;
    private static Randomizer randomizer = null;
    private static Encryptor encryptor = null;
    private static Executor executor = null;
    private static Validator validator = null;
    private static HTTPUtilities httpUtilities = null;
    private static Logger defaultLogger = null;
    private static SecurityConfiguration securityConfiguration = null;
    private static final String securityConfigurationImplName = System.getProperty("org.owasp.esapi.SecurityConfiguration", "org.owasp.esapi.reference.DefaultSecurityConfiguration");

    private ESAPI() {
    }

    public static void clearCurrent() {
        ESAPI.authenticator().clearCurrent();
        ESAPI.httpUtilities().clearCurrent();
    }

    public static HttpServletRequest currentRequest() {
        return ESAPI.httpUtilities().getCurrentRequest();
    }

    public static HttpServletResponse currentResponse() {
        return ESAPI.httpUtilities().getCurrentResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessController accessController() {
        Object object = accessorLock;
        synchronized (object) {
            if (accessController == null) {
                String accessControllerName = ESAPI.securityConfiguration().getAccessControlImplementation();
                accessController = (AccessController)new ObjFactory().make(accessControllerName, "AccessController");
            }
        }
        return accessController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessController setAccessController(AccessController controller) {
        AccessController previousController;
        Object object = accessorLock;
        synchronized (object) {
            previousController = accessController;
            accessController = controller;
        }
        return previousController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Authenticator authenticator() {
        Object object = accessorLock;
        synchronized (object) {
            if (authenticator == null) {
                String authenticatorName = ESAPI.securityConfiguration().getAuthenticationImplementation();
                authenticator = (Authenticator)new ObjFactory().make(authenticatorName, "Authenticator");
            }
        }
        return authenticator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Authenticator setAuthenticator(Authenticator authenticator) {
        Authenticator previousAuthenticator;
        Object object = accessorLock;
        synchronized (object) {
            previousAuthenticator = ESAPI.authenticator;
            ESAPI.authenticator = authenticator;
        }
        return previousAuthenticator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Encoder encoder() {
        Object object = accessorLock;
        synchronized (object) {
            if (encoder == null) {
                String encoderName = ESAPI.securityConfiguration().getEncoderImplementation();
                encoder = (Encoder)new ObjFactory().make(encoderName, "Encoder");
            }
        }
        return encoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Encoder setEncoder(Encoder encoder) {
        Encoder previousEncoder;
        Object object = accessorLock;
        synchronized (object) {
            previousEncoder = ESAPI.encoder;
            ESAPI.encoder = encoder;
        }
        return previousEncoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Encryptor encryptor() {
        Object object = accessorLock;
        synchronized (object) {
            if (encryptor == null) {
                String encryptorName = ESAPI.securityConfiguration().getEncryptionImplementation();
                encryptor = (Encryptor)new ObjFactory().make(encryptorName, "Encryptor");
            }
        }
        return encryptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Encryptor setEncryptor(Encryptor encryptor) {
        Encryptor previousEncryptor;
        Object object = accessorLock;
        synchronized (object) {
            previousEncryptor = ESAPI.encryptor;
            ESAPI.encryptor = encryptor;
        }
        return previousEncryptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Executor executor() {
        Object object = accessorLock;
        synchronized (object) {
            if (executor == null) {
                String executorName = ESAPI.securityConfiguration().getExecutorImplementation();
                executor = (Executor)new ObjFactory().make(executorName, "Executor");
            }
        }
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Executor setExecutor(Executor executor) {
        Executor previousExecutor;
        Object object = accessorLock;
        synchronized (object) {
            previousExecutor = ESAPI.executor;
            ESAPI.executor = executor;
        }
        return previousExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HTTPUtilities httpUtilities() {
        Object object = accessorLock;
        synchronized (object) {
            if (httpUtilities == null) {
                String httpUtilitiesName = ESAPI.securityConfiguration().getHTTPUtilitiesImplementation();
                httpUtilities = (HTTPUtilities)new ObjFactory().make(httpUtilitiesName, "HTTPUtilities");
            }
        }
        return httpUtilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HTTPUtilities setHttpUtilities(HTTPUtilities httpUtilities) {
        HTTPUtilities previousHTTPUtilities;
        Object object = accessorLock;
        synchronized (object) {
            previousHTTPUtilities = ESAPI.httpUtilities;
            ESAPI.httpUtilities = httpUtilities;
        }
        return previousHTTPUtilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntrusionDetector intrusionDetector() {
        Object object = accessorLock;
        synchronized (object) {
            if (intrusionDetector == null) {
                String intrusionDetectorName = ESAPI.securityConfiguration().getIntrusionDetectionImplementation();
                intrusionDetector = (IntrusionDetector)new ObjFactory().make(intrusionDetectorName, "IntrusionDetector");
            }
        }
        return intrusionDetector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntrusionDetector setIntrusionDetector(IntrusionDetector intrusionDetector) {
        IntrusionDetector previousIntrusionDetector;
        Object object = accessorLock;
        synchronized (object) {
            previousIntrusionDetector = ESAPI.intrusionDetector;
            ESAPI.intrusionDetector = intrusionDetector;
        }
        return previousIntrusionDetector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LogFactory logFactory() {
        Object object = accessorLock;
        synchronized (object) {
            if (logFactory == null) {
                String logFactoryName = ESAPI.securityConfiguration().getLogImplementation();
                logFactory = (LogFactory)new ObjFactory().make(logFactoryName, "LogFactory");
            }
        }
        return logFactory;
    }

    public static Logger getLogger(Class clazz) {
        return ESAPI.logFactory().getLogger(clazz);
    }

    public static Logger getLogger(String moduleName) {
        return ESAPI.logFactory().getLogger(moduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger log() {
        Object object = accessorLock;
        synchronized (object) {
            if (defaultLogger == null) {
                defaultLogger = ESAPI.logFactory().getLogger("DefaultLogger");
            }
        }
        return defaultLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogFactory setLogFactory(LogFactory factory) {
        LogFactory previousLogFactory;
        Object object = accessorLock;
        synchronized (object) {
            previousLogFactory = logFactory;
            logFactory = factory;
        }
        return previousLogFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Randomizer randomizer() {
        Object object = accessorLock;
        synchronized (object) {
            if (randomizer == null) {
                String randomizerName = ESAPI.securityConfiguration().getRandomizerImplementation();
                randomizer = (Randomizer)new ObjFactory().make(randomizerName, "Randomizer");
            }
        }
        return randomizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Randomizer setRandomizer(Randomizer randomizer) {
        Randomizer previousRandomizer;
        Object object = accessorLock;
        synchronized (object) {
            previousRandomizer = ESAPI.randomizer;
            ESAPI.randomizer = randomizer;
        }
        return previousRandomizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityConfiguration securityConfiguration() {
        Object object = accessorLock;
        synchronized (object) {
            if (securityConfiguration == null) {
                securityConfiguration = (SecurityConfiguration)new ObjFactory().make(securityConfigurationImplName, "SecurityConfiguration");
            }
        }
        return securityConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityConfiguration setSecurityConfiguration(SecurityConfiguration securityConfiguration) {
        SecurityConfiguration previousSecurityConfiguration;
        Object object = accessorLock;
        synchronized (object) {
            if (securityConfiguration == null) {
                throw new NullPointerException("ESAPI.setSecurityConfiguration(): null passed in. Security configuration unchanged.");
            }
            previousSecurityConfiguration = ESAPI.securityConfiguration;
            ESAPI.securityConfiguration = securityConfiguration;
        }
        return previousSecurityConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Validator validator() {
        Object object = accessorLock;
        synchronized (object) {
            if (validator == null) {
                String validatorName = ESAPI.securityConfiguration().getValidationImplementation();
                validator = (Validator)new ObjFactory().make(validatorName, "Validator");
            }
        }
        return validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Validator setValidator(Validator validator) {
        Validator previousValidator;
        Object object = accessorLock;
        synchronized (object) {
            previousValidator = ESAPI.validator;
            ESAPI.validator = validator;
        }
        return previousValidator;
    }
}

