/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SecurityConfiguration {
    public String getApplicationName();

    public String getLogImplementation();

    public String getAuthenticationImplementation();

    public String getEncoderImplementation();

    public String getAccessControlImplementation();

    public String getIntrusionDetectionImplementation();

    public String getRandomizerImplementation();

    public String getEncryptionImplementation();

    public String getValidationImplementation();

    public Pattern getValidationPattern(String var1);

    public String getExecutorImplementation();

    public String getHTTPUtilitiesImplementation();

    public byte[] getMasterKey();

    public File getUploadDirectory();

    public File getUploadTempDirectory();

    public int getEncryptionKeyLength();

    public byte[] getMasterSalt();

    public List<String> getAllowedExecutables();

    public List<String> getAllowedFileExtensions();

    public int getAllowedFileUploadSize();

    public String getPasswordParameterName();

    public String getUsernameParameterName();

    public String getEncryptionAlgorithm();

    public String getCipherTransformation();

    @Deprecated
    public String setCipherTransformation(String var1);

    public String getPreferredJCEProvider();

    public boolean useMACforCipherText();

    public boolean overwritePlainText();

    public String getIVType();

    public String getFixedIV();

    public List<String> getCombinedCipherModes();

    public List<String> getAdditionalAllowedCipherModes();

    public String getHashAlgorithm();

    public int getHashIterations();

    public String getCharacterEncoding();

    public boolean getAllowMultipleEncoding();

    public List<String> getDefaultCanonicalizationCodecs();

    public String getDigitalSignatureAlgorithm();

    public int getDigitalSignatureKeyLength();

    public String getRandomAlgorithm();

    public int getAllowedLoginAttempts();

    public int getMaxOldPasswordHashes();

    public boolean getDisableIntrusionDetection();

    public Threshold getQuota(String var1);

    public File getResourceFile(String var1);

    public boolean getForceHttpOnlySession();

    public boolean getForceSecureSession();

    public boolean getForceHttpOnlyCookies();

    public boolean getForceSecureCookies();

    public InputStream getResourceStream(String var1) throws IOException;

    public void setResourceDirectory(String var1);

    public String getResponseContentType();

    public long getRememberTokenDuration();

    public int getSessionIdleTimeoutLength();

    public int getSessionAbsoluteTimeoutLength();

    public boolean getLogEncodingRequired();

    public boolean getLogApplicationName();

    public boolean getLogServerIP();

    public int getLogLevel();

    public String getLogFileName();

    public int getMaxLogFileSize();

    public File getWorkingDirectory();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Threshold {
        public String name = null;
        public int count = 0;
        public long interval = 0L;
        public List<String> actions = null;

        public Threshold(String name, int count, long interval, List<String> actions) {
            this.name = name;
            this.count = count;
            this.interval = interval;
            this.actions = actions;
        }
    }
}

