/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.PushbackString;

public class CSSCodec
extends Codec {
    public String encodeCharacter(char[] immune, Character c) {
        if (CSSCodec.containsCharacter(c.charValue(), immune)) {
            return "" + c;
        }
        String hex = Codec.getHexForNonAlphanumeric(c.charValue());
        if (hex == null) {
            return "" + c;
        }
        return "\\" + hex + " ";
    }

    public Character decodeCharacter(PushbackString input) {
        input.mark();
        Character first = input.next();
        if (first == null) {
            input.reset();
            return null;
        }
        if (first.charValue() != '\\') {
            input.reset();
            return null;
        }
        Character second = input.next();
        if (second == null) {
            input.reset();
            return null;
        }
        if (PushbackString.isHexDigit(second)) {
            Character c;
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append(second);
            for (i = 0; i < 5 && (c = input.next()) != null && c.charValue() != ' '; ++i) {
                if (!PushbackString.isHexDigit(c)) {
                    input.pushback(c);
                    break;
                }
                sb.append(c);
            }
            try {
                i = Integer.parseInt(sb.toString(), 16);
                if (Character.isValidCodePoint(i)) {
                    return Character.valueOf((char)i);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return second;
    }
}

