/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

import java.io.IOException;
import java.io.PushbackReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.owasp.esapi.util.NullSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashTrie<T>
implements Map<CharSequence, T> {
    private Node<T> root;
    private int maxKeyLen;
    private int size;

    public HashTrie() {
        this.clear();
    }

    public Map.Entry<CharSequence, T> getLongestMatch(CharSequence key) {
        if (this.root == null || key == null) {
            return null;
        }
        return this.root.getLongestMatch(key, 0);
    }

    public Map.Entry<CharSequence, T> getLongestMatch(PushbackReader keyIn) throws IOException {
        if (this.root == null || keyIn == null) {
            return null;
        }
        return this.root.getLongestMatch(keyIn, new StringBuilder());
    }

    public int getMaxKeyLength() {
        return this.maxKeyLen;
    }

    @Override
    public void clear() {
        this.root = null;
        this.maxKeyLen = -1;
        this.size = 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.root == null) {
            return false;
        }
        return this.root.containsValue(value);
    }

    @Override
    public T put(CharSequence key, T value) throws NullPointerException {
        T old;
        if (key == null) {
            throw new NullPointerException("Null keys are not handled");
        }
        if (value == null) {
            throw new NullPointerException("Null values are not handled");
        }
        if (this.root == null) {
            this.root = new Node();
        }
        if ((old = this.root.put(key, 0, value)) != null) {
            return old;
        }
        int len = key.length();
        if (len > this.maxKeyLen) {
            this.maxKeyLen = len;
        }
        ++this.size;
        return null;
    }

    @Override
    public T remove(Object key) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends CharSequence, ? extends T> map) {
        for (Map.Entry<CharSequence, T> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<CharSequence> keySet() {
        HashSet<CharSequence> keys = new HashSet<CharSequence>(this.size);
        if (this.root == null) {
            return keys;
        }
        return this.root.keySet(new StringBuilder(), keys);
    }

    @Override
    public Collection<T> values() {
        ArrayList values = new ArrayList(this.size());
        if (this.root == null) {
            return values;
        }
        return this.root.values(values);
    }

    @Override
    public Set<Map.Entry<CharSequence, T>> entrySet() {
        HashSet<Map.Entry<CharSequence, T>> entries = new HashSet<Map.Entry<CharSequence, T>>(this.size());
        if (this.root == null) {
            return entries;
        }
        return this.root.entrySet(new StringBuilder(), entries);
    }

    @Override
    public T get(Object key) {
        if (this.root == null || key == null) {
            return null;
        }
        if (!(key instanceof CharSequence)) {
            return null;
        }
        return this.root.get((CharSequence)key, 0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        return ((Object)this.entrySet()).equals(((Map)other).entrySet());
    }

    @Override
    public int hashCode() {
        return ((Object)this.entrySet()).hashCode();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append("{ ");
        for (Map.Entry<CharSequence, T> entry : this.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry.toString());
        }
        sb.append(" }");
        return sb.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<T> {
        private T value = null;
        private Map<Character, Node<T>> nextMap;

        private Node() {
        }

        private static <T> Map<Character, Node<T>> newNodeMap() {
            return new HashMap<Character, Node<T>>();
        }

        private static <T> Map<Character, Node<T>> newNodeMap(Map<Character, Node<T>> prev) {
            return new HashMap<Character, Node<T>>(prev);
        }

        void setValue(T value) {
            this.value = value;
        }

        Node<T> getNextNode(Character ch) {
            if (this.nextMap == null) {
                return null;
            }
            return this.nextMap.get(ch);
        }

        T put(CharSequence key, int pos, T addValue) {
            Node<T> nextNode;
            if (key.length() == pos) {
                T old = this.value;
                this.setValue(addValue);
                return old;
            }
            Character ch = Character.valueOf(key.charAt(pos));
            if (this.nextMap == null) {
                this.nextMap = Node.newNodeMap();
                nextNode = new Node<T>();
                this.nextMap.put(ch, nextNode);
            } else {
                nextNode = this.nextMap.get(ch);
                if (nextNode == null) {
                    nextNode = new Node<T>();
                    this.nextMap.put(ch, nextNode);
                }
            }
            return nextNode.put(key, pos + 1, addValue);
        }

        T get(CharSequence key, int pos) {
            if (key.length() <= pos) {
                return this.value;
            }
            Node<T> nextNode = this.getNextNode(Character.valueOf(key.charAt(pos)));
            if (nextNode == null) {
                return null;
            }
            return nextNode.get(key, pos + 1);
        }

        Entry<T> getLongestMatch(CharSequence key, int pos) {
            if (key.length() <= pos) {
                return Entry.newInstanceIfNeeded(key, this.value);
            }
            Node<T> nextNode = this.getNextNode(Character.valueOf(key.charAt(pos)));
            if (nextNode == null) {
                return Entry.newInstanceIfNeeded(key, pos, this.value);
            }
            Entry<T> ret = nextNode.getLongestMatch(key, pos + 1);
            if (ret != null) {
                return ret;
            }
            return Entry.newInstanceIfNeeded(key, pos, this.value);
        }

        Entry<T> getLongestMatch(PushbackReader keyIn, StringBuilder key) throws IOException {
            int c = keyIn.read();
            if (c < 0) {
                return Entry.newInstanceIfNeeded(key, this.value);
            }
            char ch = (char)c;
            int prevLen = key.length();
            key.append(ch);
            Node<T> nextNode = this.getNextNode(Character.valueOf(ch));
            if (nextNode == null) {
                return Entry.newInstanceIfNeeded(key, this.value);
            }
            Entry<T> ret = nextNode.getLongestMatch(keyIn, key);
            if (ret != null) {
                return ret;
            }
            key.setLength(prevLen);
            keyIn.unread(c);
            return Entry.newInstanceIfNeeded(key, this.value);
        }

        void remap() {
            if (this.nextMap == null) {
                return;
            }
            this.nextMap = Node.newNodeMap(this.nextMap);
            for (Node<T> node : this.nextMap.values()) {
                node.remap();
            }
        }

        boolean containsValue(Object toFind) {
            if (this.value != null && toFind.equals(this.value)) {
                return true;
            }
            if (this.nextMap == null) {
                return false;
            }
            for (Node<T> node : this.nextMap.values()) {
                if (!node.containsValue(toFind)) continue;
                return true;
            }
            return false;
        }

        Collection<T> values(Collection<T> values) {
            if (this.value != null) {
                values.add(this.value);
            }
            if (this.nextMap == null) {
                return values;
            }
            for (Node<T> node : this.nextMap.values()) {
                node.values(values);
            }
            return values;
        }

        Set<CharSequence> keySet(StringBuilder key, Set<CharSequence> keys) {
            int len = key.length();
            if (this.value != null) {
                keys.add(key.toString());
            }
            if (this.nextMap != null && this.nextMap.size() > 0) {
                key.append('X');
                for (Map.Entry<Character, Node<T>> entry : this.nextMap.entrySet()) {
                    key.setCharAt(len, entry.getKey().charValue());
                    entry.getValue().keySet(key, keys);
                }
                key.setLength(len);
            }
            return keys;
        }

        Set<Map.Entry<CharSequence, T>> entrySet(StringBuilder key, Set<Map.Entry<CharSequence, T>> entries) {
            int len = key.length();
            if (this.value != null) {
                entries.add(new Entry<T>(key.toString(), this.value));
            }
            if (this.nextMap != null && this.nextMap.size() > 0) {
                key.append('X');
                for (Map.Entry<Character, Node<T>> entry : this.nextMap.entrySet()) {
                    key.setCharAt(len, entry.getKey().charValue());
                    entry.getValue().entrySet(key, entries);
                }
                key.setLength(len);
            }
            return entries;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<T>
    implements Map.Entry<CharSequence, T> {
        private CharSequence key;
        private T value;

        Entry(CharSequence key, T value) {
            this.key = key;
            this.value = value;
        }

        static <T> Entry<T> newInstanceIfNeeded(CharSequence key, int keyLength, T value) {
            if (value == null || key == null) {
                return null;
            }
            if (key.length() > keyLength) {
                key = key.subSequence(0, keyLength);
            }
            return new Entry<T>(key, value);
        }

        static <T> Entry<T> newInstanceIfNeeded(CharSequence key, T value) {
            if (value == null || key == null) {
                return null;
            }
            return new Entry<T>(key, value);
        }

        @Override
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public T setValue(T value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Map.Entry other) {
            return NullSafe.equals(this.key, other.getKey()) && NullSafe.equals(this.value, other.getValue());
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                return this.equals((Map.Entry)o);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return NullSafe.hashCode(this.key) ^ NullSafe.hashCode(this.value);
        }

        public String toString() {
            return NullSafe.toString(this.key) + " => " + NullSafe.toString(this.value);
        }
    }
}

