/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.PushbackString;

public class MySQLCodec
extends Codec {
    public static final int MYSQL_MODE = 0;
    public static final int ANSI_MODE = 1;
    private int mode = 0;

    public MySQLCodec(int mode) {
        this.mode = mode;
    }

    public String encodeCharacter(char[] immune, Character c) {
        char ch = c.charValue();
        if (MySQLCodec.containsCharacter(ch, immune)) {
            return "" + ch;
        }
        String hex = Codec.getHexForNonAlphanumeric(ch);
        if (hex == null) {
            return "" + ch;
        }
        switch (this.mode) {
            case 1: {
                return this.encodeCharacterANSI(c);
            }
            case 0: {
                return this.encodeCharacterMySQL(c);
            }
        }
        return null;
    }

    private String encodeCharacterANSI(Character c) {
        if (c.charValue() == '\'') {
            return "''";
        }
        return "" + c;
    }

    private String encodeCharacterMySQL(Character c) {
        char ch = c.charValue();
        if (ch == '\u0000') {
            return "\\0";
        }
        if (ch == '\b') {
            return "\\b";
        }
        if (ch == '\t') {
            return "\\t";
        }
        if (ch == '\n') {
            return "\\n";
        }
        if (ch == '\r') {
            return "\\r";
        }
        if (ch == '\u001a') {
            return "\\Z";
        }
        if (ch == '\"') {
            return "\\\"";
        }
        if (ch == '%') {
            return "\\%";
        }
        if (ch == '\'') {
            return "\\'";
        }
        if (ch == '\\') {
            return "\\\\";
        }
        if (ch == '_') {
            return "\\_";
        }
        return "\\" + c;
    }

    public Character decodeCharacter(PushbackString input) {
        switch (this.mode) {
            case 1: {
                return this.decodeCharacterANSI(input);
            }
            case 0: {
                return this.decodeCharacterMySQL(input);
            }
        }
        return null;
    }

    private Character decodeCharacterANSI(PushbackString input) {
        input.mark();
        Character first = input.next();
        if (first == null) {
            input.reset();
            return null;
        }
        if (first.charValue() != '\'') {
            input.reset();
            return null;
        }
        Character second = input.next();
        if (second == null) {
            input.reset();
            return null;
        }
        if (second.charValue() != '\'') {
            input.reset();
            return null;
        }
        return Character.valueOf('\'');
    }

    private Character decodeCharacterMySQL(PushbackString input) {
        input.mark();
        Character first = input.next();
        if (first == null) {
            input.reset();
            return null;
        }
        if (first.charValue() != '\\') {
            input.reset();
            return null;
        }
        Character second = input.next();
        if (second == null) {
            input.reset();
            return null;
        }
        if (second.charValue() == '0') {
            return Character.valueOf('\u0000');
        }
        if (second.charValue() == 'b') {
            return Character.valueOf('\b');
        }
        if (second.charValue() == 't') {
            return Character.valueOf('\t');
        }
        if (second.charValue() == 'n') {
            return Character.valueOf('\n');
        }
        if (second.charValue() == 'r') {
            return Character.valueOf('\r');
        }
        if (second.charValue() == 'z') {
            return Character.valueOf('\u001a');
        }
        if (second.charValue() == '\"') {
            return Character.valueOf('\"');
        }
        if (second.charValue() == '%') {
            return Character.valueOf('%');
        }
        if (second.charValue() == '\'') {
            return Character.valueOf('\'');
        }
        if (second.charValue() == '\\') {
            return Character.valueOf('\\');
        }
        if (second.charValue() == '_') {
            return Character.valueOf('_');
        }
        return second;
    }
}

