/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.crypto;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import javax.crypto.Cipher;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.StringUtilities;
import org.owasp.esapi.crypto.CryptoHelper;
import org.owasp.esapi.util.NullSafe;

public final class CipherSpec
implements Serializable {
    private static final long serialVersionUID = 20090822L;
    private String cipher_xform_ = ESAPI.securityConfiguration().getCipherTransformation();
    private int keySize_ = ESAPI.securityConfiguration().getEncryptionKeyLength();
    private int blockSize_ = 16;
    private byte[] iv_ = null;

    public CipherSpec(String cipherXform, int keySize, int blockSize, byte[] iv) {
        this.setCipherTransformation(cipherXform);
        this.setKeySize(keySize);
        this.setBlockSize(blockSize);
        this.setIV(iv);
    }

    public CipherSpec(String cipherXform, int keySize, int blockSize) {
        this.setCipherTransformation(cipherXform);
        this.setKeySize(keySize);
        this.setBlockSize(blockSize);
    }

    public CipherSpec(String cipherXform, int keySize) {
        this.setCipherTransformation(cipherXform);
        this.setKeySize(keySize);
    }

    public CipherSpec(String cipherXform, int keySize, byte[] iv) {
        this.setCipherTransformation(cipherXform);
        this.setKeySize(keySize);
        this.setIV(iv);
    }

    public CipherSpec(Cipher cipher) {
        this.setCipherTransformation(cipher.getAlgorithm(), true);
        this.setBlockSize(cipher.getBlockSize());
        if (cipher.getIV() != null) {
            this.setIV(cipher.getIV());
        }
    }

    public CipherSpec(Cipher cipher, int keySize) {
        this(cipher);
        this.setKeySize(keySize);
    }

    public CipherSpec(byte[] iv) {
        this.setIV(iv);
    }

    public CipherSpec() {
    }

    public CipherSpec setCipherTransformation(String cipherXform) {
        this.setCipherTransformation(cipherXform, false);
        return this;
    }

    private CipherSpec setCipherTransformation(String cipherXform, boolean fromCipher) {
        assert (StringUtilities.notNullOrEmpty(cipherXform, true)) : "cipherXform may not be null or empty";
        int parts = cipherXform.split("/").length;
        assert (fromCipher || parts == 3) : "Malformed cipherXform (" + cipherXform + "); must have form: \"alg/mode/paddingscheme\"";
        if (fromCipher && parts != 3) {
            if (parts == 1) {
                cipherXform = cipherXform + "/ECB/NoPadding";
            } else if (parts == 2) {
                cipherXform = cipherXform + "/NoPadding";
            } else if (parts != 3) {
                throw new IllegalArgumentException("Cipher transformation '" + cipherXform + "' must have form \"alg/mode/paddingscheme\"");
            }
        }
        assert (cipherXform.split("/").length == 3) : "Implementation error setCipherTransformation()";
        this.cipher_xform_ = cipherXform;
        return this;
    }

    public String getCipherTransformation() {
        return this.cipher_xform_;
    }

    public CipherSpec setKeySize(int keySize) {
        assert (keySize > 0) : "keySize must be > 0; keySize=" + keySize;
        this.keySize_ = keySize;
        return this;
    }

    public int getKeySize() {
        return this.keySize_;
    }

    public CipherSpec setBlockSize(int blockSize) {
        assert (blockSize > 0) : "blockSize must be > 0; blockSize=" + blockSize;
        this.blockSize_ = blockSize;
        return this;
    }

    public int getBlockSize() {
        return this.blockSize_;
    }

    public String getCipherAlgorithm() {
        return this.getFromCipherXform(CipherTransformationComponent.ALG);
    }

    public String getCipherMode() {
        return this.getFromCipherXform(CipherTransformationComponent.MODE);
    }

    public String getPaddingScheme() {
        return this.getFromCipherXform(CipherTransformationComponent.PADDING);
    }

    public byte[] getIV() {
        return this.iv_;
    }

    public CipherSpec setIV(byte[] iv) {
        assert (this.requiresIV() && iv != null && iv.length != 0) : "Required IV cannot be null or 0 length";
        if (iv != null) {
            this.iv_ = new byte[iv.length];
            CryptoHelper.copyByteArray(iv, this.iv_);
        }
        return this;
    }

    public boolean requiresIV() {
        String cm = this.getCipherMode();
        return !"ECB".equalsIgnoreCase(cm);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CipherSpec: ");
        sb.append(this.getCipherTransformation()).append("; keysize= ").append(this.getKeySize());
        sb.append(" bits; blocksize= ").append(this.getBlockSize()).append(" bytes");
        byte[] iv = this.getIV();
        String ivLen = null;
        ivLen = iv != null ? "" + iv.length : "[No IV present (not set or not required)]";
        sb.append("; IV length = ").append(ivLen).append(" bytes.");
        return sb.toString();
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof CipherSpec) {
            CipherSpec that = (CipherSpec)other;
            result = that.canEqual(this) && NullSafe.equals(this.cipher_xform_, that.cipher_xform_) && this.keySize_ == that.keySize_ && this.blockSize_ == that.blockSize_ && CryptoHelper.arrayCompare(this.iv_, that.iv_);
        }
        return result;
    }

    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCipherTransformation());
        sb.append("" + this.getKeySize());
        sb.append("" + this.getBlockSize());
        byte[] iv = this.getIV();
        if (iv != null && iv.length > 0) {
            String ivStr = null;
            try {
                ivStr = new String(iv, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                ivStr = new String(iv);
            }
            sb.append(ivStr);
        }
        return sb.toString().hashCode();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CipherSpec;
    }

    private String getFromCipherXform(CipherTransformationComponent component) {
        int part = component.ordinal();
        String[] parts = this.getCipherTransformation().split("/");
        assert (parts.length == 3) : "Invalid cipher transformation: " + this.getCipherTransformation();
        return parts[part];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CipherTransformationComponent {
        ALG,
        MODE,
        PADDING;

    }
}

