/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.crypto;

import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class SecurityProviderLoader {
    private static Logger logger = ESAPI.getLogger("SecurityProviderLoader");
    private static Hashtable<String, String> jceProviders = new Hashtable();

    public static int insertProviderAt(String algProvider, int pos) throws NoSuchProviderException {
        Class<?> providerClass = null;
        String clzName = null;
        Provider cryptoProvider = null;
        assert (pos == -1 || pos >= 1) : "Position pos must be -1 or integer >= 1";
        try {
            if (algProvider.indexOf(46) != -1) {
                clzName = algProvider;
            } else if (jceProviders.containsKey(algProvider)) {
                clzName = jceProviders.get(algProvider);
            } else {
                throw new NoSuchProviderException("Unable to locate Provider class for provider " + algProvider + ". Try using fully qualified class name " + "or check provider name for typos. Builtin provider names are: " + jceProviders.toString());
            }
            providerClass = Class.forName(clzName);
            cryptoProvider = (Provider)providerClass.newInstance();
            int ret = pos == -1 ? Security.addProvider(cryptoProvider) : Security.insertProviderAt(cryptoProvider, pos);
            if (ret == -1) {
                String msg = "JCE provider '" + algProvider + "' already loaded";
                if (pos == -1) {
                    logger.info(Logger.SECURITY_SUCCESS, msg);
                } else {
                    logger.warning(Logger.SECURITY_FAILURE, msg);
                }
            } else {
                logger.debug(Logger.EVENT_SUCCESS, "Successfully loaded preferred JCE provider " + algProvider + " at position " + pos);
            }
            return ret;
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error(Logger.SECURITY_FAILURE, "Failed to insert failed crypto  provider " + algProvider + " at position " + pos, ex);
            throw new NoSuchProviderException("Failed to insert crypto  provider for " + algProvider + "; exception msg: " + ex.toString());
        }
    }

    public static int loadESAPIPreferredJCEProvider() throws NoSuchProviderException {
        String prefJCEProvider = ESAPI.securityConfiguration().getPreferredJCEProvider();
        try {
            if (prefJCEProvider == null || prefJCEProvider.trim().length() == 0) {
                logger.debug(Logger.EVENT_SUCCESS, "No Encryptor.PreferredJCEProvider specified.");
                return -1;
            }
            return SecurityProviderLoader.insertProviderAt(prefJCEProvider, 1);
        }
        catch (NoSuchProviderException ex) {
            logger.error(Logger.SECURITY_FAILURE, "failed to load *preferred* JCE crypto" + prefJCEProvider);
            throw ex;
        }
    }

    static {
        jceProviders.put("SunJCE", "com.sun.crypto.provider.SunJCE");
        jceProviders.put("IBMJCE", "com.ibm.crypto.provider.IBMJCE");
        jceProviders.put("GnuCrypto", "gnu.crypto.jce.GnuCrypto");
        jceProviders.put("BC", "org.bouncycastle.jce.provider.BouncyCastleProvider");
        jceProviders.put("IAIK", "iaik.security.provider.IAIK");
        jceProviders.put("CryptixCrypto", "cryptix.jce.provider.CryptixCrypto");
        jceProviders.put("Cryptix", "cryptix.jce.provider.CryptixCrypto");
        jceProviders.put("ABA", "au.net.aba.crypto.provider.ABAProvider");
    }
}

