/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.filters;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.StringUtilities;
import org.owasp.esapi.ValidationErrorList;
import org.owasp.esapi.errors.IntrusionException;
import org.owasp.esapi.errors.ValidationException;

public class SecurityWrapperResponse
extends HttpServletResponseWrapper
implements HttpServletResponse {
    private final Logger logger = ESAPI.getLogger("SecurityWrapperResponse");
    private String mode = "log";

    public SecurityWrapperResponse(HttpServletResponse response) {
        super(response);
    }

    public SecurityWrapperResponse(HttpServletResponse response, String mode) {
        super(response);
        this.mode = mode;
    }

    private HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)super.getResponse();
    }

    public void addCookie(Cookie cookie) {
        String name = cookie.getName();
        String value = cookie.getValue();
        int maxAge = cookie.getMaxAge();
        String domain = cookie.getDomain();
        String path = cookie.getPath();
        boolean secure = cookie.getSecure();
        ValidationErrorList errors = new ValidationErrorList();
        String cookieName = ESAPI.validator().getValidInput("cookie name", name, "HTTPCookieName", 50, false, errors);
        String cookieValue = ESAPI.validator().getValidInput("cookie value", value, "HTTPCookieValue", 5000, false, errors);
        if (errors.size() == 0) {
            String header = this.createCookieHeader(name, value, maxAge, domain, path, secure);
            this.addHeader("Set-Cookie", header);
            return;
        }
        if (this.mode.equals("skip")) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to add unsafe data to cookie (skip mode). Skipping cookie and continuing.");
            return;
        }
        if (this.mode.equals("log")) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to add unsafe data to cookie (log mode). Adding unsafe cookie anyway and continuing.");
            this.getHttpServletResponse().addCookie(cookie);
            return;
        }
        if (this.mode.equals("sanitize")) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to add unsafe data to cookie (sanitize mode). Sanitizing cookie and continuing.");
            String header = this.createCookieHeader(cookieName, cookieValue, maxAge, domain, path, secure);
            this.addHeader("Set-Cookie", header);
            return;
        }
        throw new IntrusionException("Security error", "Attempt to add unsafe data to cookie (throw mode)");
    }

    private String createCookieHeader(String name, String value, int maxAge, String domain, String path, boolean secure) {
        String header = name + "=" + value;
        header = header + "; Max-Age=" + maxAge;
        if (domain != null) {
            header = header + "; Domain=" + domain;
        }
        if (path != null) {
            header = header + "; Path=" + path;
        }
        header = header + "; Secure";
        header = header + "; HttpOnly";
        return header;
    }

    public void addDateHeader(String name, long date) {
        try {
            String safeName = ESAPI.validator().getValidInput("safeSetDateHeader", name, "HTTPHeaderName", 20, false);
            this.getHttpServletResponse().addDateHeader(safeName, date);
        }
        catch (ValidationException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to set invalid date header name denied", e);
        }
    }

    public void addHeader(String name, String value) {
        try {
            String strippedName = StringUtilities.stripControls(name);
            String strippedValue = StringUtilities.stripControls(value);
            String safeName = ESAPI.validator().getValidInput("addHeader", strippedName, "HTTPHeaderName", 20, false);
            String safeValue = ESAPI.validator().getValidInput("addHeader", strippedValue, "HTTPHeaderValue", 500, false);
            this.getHttpServletResponse().setHeader(safeName, safeValue);
        }
        catch (ValidationException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to add invalid header denied", e);
        }
    }

    public void addIntHeader(String name, int value) {
        try {
            String safeName = ESAPI.validator().getValidInput("safeSetDateHeader", name, "HTTPHeaderName", 20, false);
            this.getHttpServletResponse().addIntHeader(safeName, value);
        }
        catch (ValidationException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to set invalid int header name denied", e);
        }
    }

    public boolean containsHeader(String name) {
        return this.getHttpServletResponse().containsHeader(name);
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    @Deprecated
    public String encodeUrl(String url) {
        return url;
    }

    public String encodeURL(String url) {
        return url;
    }

    public void flushBuffer() throws IOException {
        this.getHttpServletResponse().flushBuffer();
    }

    public int getBufferSize() {
        return this.getHttpServletResponse().getBufferSize();
    }

    public String getCharacterEncoding() {
        return this.getHttpServletResponse().getCharacterEncoding();
    }

    public String getContentType() {
        return this.getHttpServletResponse().getContentType();
    }

    public Locale getLocale() {
        return this.getHttpServletResponse().getLocale();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.getHttpServletResponse().getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        return this.getHttpServletResponse().getWriter();
    }

    public boolean isCommitted() {
        return this.getHttpServletResponse().isCommitted();
    }

    public void reset() {
        this.getHttpServletResponse().reset();
    }

    public void resetBuffer() {
        this.getHttpServletResponse().resetBuffer();
    }

    public void sendError(int sc) throws IOException {
        this.getHttpServletResponse().sendError(200, this.getHTTPMessage(sc));
    }

    public void sendError(int sc, String msg) throws IOException {
        this.getHttpServletResponse().sendError(200, ESAPI.encoder().encodeForHTML(msg));
    }

    public void sendRedirect(String location) throws IOException {
        if (!ESAPI.validator().isValidRedirectLocation("Redirect", location, false)) {
            this.logger.fatal(Logger.SECURITY_FAILURE, "Bad redirect location: " + location);
            throw new IOException("Redirect failed");
        }
        this.getHttpServletResponse().sendRedirect(location);
    }

    public void setBufferSize(int size) {
        this.getHttpServletResponse().setBufferSize(size);
    }

    public void setCharacterEncoding(String charset) {
        this.getHttpServletResponse().setCharacterEncoding(ESAPI.securityConfiguration().getCharacterEncoding());
    }

    public void setContentLength(int len) {
        this.getHttpServletResponse().setContentLength(len);
    }

    public void setContentType(String type) {
        this.getHttpServletResponse().setContentType(type);
    }

    public void setDateHeader(String name, long date) {
        try {
            String safeName = ESAPI.validator().getValidInput("safeSetDateHeader", name, "HTTPHeaderName", 20, false);
            this.getHttpServletResponse().setDateHeader(safeName, date);
        }
        catch (ValidationException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to set invalid date header name denied", e);
        }
    }

    public void setHeader(String name, String value) {
        try {
            String strippedName = StringUtilities.stripControls(name);
            String strippedValue = StringUtilities.stripControls(value);
            String safeName = ESAPI.validator().getValidInput("setHeader", strippedName, "HTTPHeaderName", 20, false);
            String safeValue = ESAPI.validator().getValidInput("setHeader", strippedValue, "HTTPHeaderValue", 500, false);
            this.getHttpServletResponse().setHeader(safeName, safeValue);
        }
        catch (ValidationException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to set invalid header denied", e);
        }
    }

    public void setIntHeader(String name, int value) {
        try {
            String safeName = ESAPI.validator().getValidInput("safeSetDateHeader", name, "HTTPHeaderName", 20, false);
            this.getHttpServletResponse().setIntHeader(safeName, value);
        }
        catch (ValidationException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to set invalid int header name denied", e);
        }
    }

    public void setLocale(Locale loc) {
        this.getHttpServletResponse().setLocale(loc);
    }

    public void setStatus(int sc) {
        this.getHttpServletResponse().setStatus(200);
    }

    @Deprecated
    public void setStatus(int sc, String sm) {
        try {
            this.sendError(200, sm);
        }
        catch (IOException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to set response status failed", e);
        }
    }

    private String getHTTPMessage(int sc) {
        return "HTTP error code: " + sc;
    }
}

