/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Executor;
import org.owasp.esapi.Logger;
import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.UnixCodec;
import org.owasp.esapi.codecs.WindowsCodec;
import org.owasp.esapi.errors.ExecutorException;

public class DefaultExecutor
implements Executor {
    private final Logger logger = ESAPI.getLogger("Executor");
    private Codec codec = null;

    public DefaultExecutor() {
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            this.logger.warning(Logger.SECURITY_SUCCESS, "Using WindowsCodec for Executor. If this is not running on Windows this could allow injection");
            this.codec = new WindowsCodec();
        } else {
            this.logger.warning(Logger.SECURITY_SUCCESS, "Using UnixCodec for Executor. If this is not running on Unix this could allow injection");
            this.codec = new UnixCodec();
        }
    }

    public String executeSystemCommand(File executable, List params) throws ExecutorException {
        File workdir = ESAPI.securityConfiguration().getWorkingDirectory();
        boolean logParams = false;
        return this.executeSystemCommand(executable, params, workdir, this.codec, logParams);
    }

    public String executeSystemCommand(File executable, List params, File workdir, Codec codec, boolean logParams) throws ExecutorException {
        try {
            if (!executable.exists()) {
                throw new ExecutorException("Execution failure", "No such executable: " + executable);
            }
            if (!executable.isAbsolute()) {
                throw new ExecutorException("Execution failure", "Attempt to invoke an executable using a non-absolute path: " + executable);
            }
            if (!executable.getPath().equals(executable.getCanonicalPath())) {
                throw new ExecutorException("Execution failure", "Attempt to invoke an executable using a non-canonical path: " + executable);
            }
            List<String> approved = ESAPI.securityConfiguration().getAllowedExecutables();
            if (!approved.contains(executable.getPath())) {
                throw new ExecutorException("Execution failure", "Attempt to invoke executable that is not listed as an approved executable in ESAPI configuration: " + executable.getPath() + " not listed in " + approved);
            }
            for (int i = 0; i < params.size(); ++i) {
                String param = (String)params.get(i);
                params.set(i, ESAPI.encoder().encodeForOS(codec, param));
            }
            if (!workdir.exists()) {
                throw new ExecutorException("Execution failure", "No such working directory for running executable: " + workdir.getPath());
            }
            params.add(0, executable.getCanonicalPath());
            ProcessBuilder pb = new ProcessBuilder(params);
            Map<String, String> env = pb.environment();
            env.clear();
            pb.directory(workdir);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            if (logParams) {
                this.logger.warning(Logger.SECURITY_SUCCESS, "Initiating executable: " + executable + " " + params + " in " + workdir);
            } else {
                this.logger.warning(Logger.SECURITY_SUCCESS, "Initiating executable: " + executable + " [sensitive parameters obscured] in " + workdir);
            }
            String output = this.readStream(process.getInputStream());
            String errors = this.readStream(process.getErrorStream());
            if (errors != null && errors.length() > 0) {
                this.logger.warning(Logger.SECURITY_SUCCESS, "Error during system command: " + errors);
            }
            this.logger.warning(Logger.SECURITY_SUCCESS, "System command complete");
            return output;
        }
        catch (Exception e) {
            throw new ExecutorException("Execution failure", "Exception thrown during execution of system command: " + e.getMessage(), e);
        }
    }

    private String readStream(InputStream is) throws IOException {
        String line;
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line + "\n");
        }
        return sb.toString();
    }
}

