/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.LogFactory;
import org.owasp.esapi.Logger;
import org.owasp.esapi.User;

public class JavaLogFactory
implements LogFactory {
    private HashMap<Serializable, Logger> loggersMap = new HashMap();

    public Logger getLogger(Class clazz) {
        Logger classLogger = this.loggersMap.get(clazz);
        if (classLogger == null) {
            classLogger = new JavaLogger(clazz.getName());
            this.loggersMap.put(clazz, classLogger);
        }
        return classLogger;
    }

    public Logger getLogger(String moduleName) {
        Logger moduleLogger = this.loggersMap.get(moduleName);
        if (moduleLogger == null) {
            moduleLogger = new JavaLogger(moduleName);
            this.loggersMap.put((Serializable)((Object)moduleName), moduleLogger);
        }
        return moduleLogger;
    }

    private static class JavaLogger
    implements Logger {
        private java.util.logging.Logger jlogger = null;
        private String moduleName = null;
        private String applicationName = ESAPI.securityConfiguration().getApplicationName();
        private static boolean logAppName = ESAPI.securityConfiguration().getLogApplicationName();
        private static boolean logServerIP = ESAPI.securityConfiguration().getLogServerIP();

        private JavaLogger(String moduleName) {
            this.moduleName = moduleName;
            this.jlogger = java.util.logging.Logger.getLogger(this.applicationName + ":" + moduleName);
        }

        public void setLevel(int level) {
            try {
                this.jlogger.setLevel(JavaLogger.convertESAPILeveltoLoggerLevel(level));
            }
            catch (IllegalArgumentException e) {
                this.error(Logger.SECURITY_FAILURE, "", e);
            }
        }

        private static Level convertESAPILeveltoLoggerLevel(int level) {
            switch (level) {
                case 0x7FFFFFFF: {
                    return Level.OFF;
                }
                case 1000: {
                    return Level.SEVERE;
                }
                case 800: {
                    return JavaLoggerLevel.ERROR_LEVEL;
                }
                case 600: {
                    return Level.WARNING;
                }
                case 400: {
                    return Level.INFO;
                }
                case 200: {
                    return Level.FINE;
                }
                case 100: {
                    return Level.FINEST;
                }
                case -2147483648: {
                    return Level.ALL;
                }
            }
            throw new IllegalArgumentException("Invalid logging level. Value was: " + level);
        }

        public void trace(Logger.EventType type, String message, Throwable throwable) {
            this.log(Level.FINEST, type, message, throwable);
        }

        public void trace(Logger.EventType type, String message) {
            this.log(Level.FINEST, type, message, null);
        }

        public void debug(Logger.EventType type, String message, Throwable throwable) {
            this.log(Level.FINE, type, message, throwable);
        }

        public void debug(Logger.EventType type, String message) {
            this.log(Level.FINE, type, message, null);
        }

        public void info(Logger.EventType type, String message) {
            this.log(Level.INFO, type, message, null);
        }

        public void info(Logger.EventType type, String message, Throwable throwable) {
            this.log(Level.INFO, type, message, throwable);
        }

        public void warning(Logger.EventType type, String message, Throwable throwable) {
            this.log(Level.WARNING, type, message, throwable);
        }

        public void warning(Logger.EventType type, String message) {
            this.log(Level.WARNING, type, message, null);
        }

        public void error(Logger.EventType type, String message, Throwable throwable) {
            this.log(Level.SEVERE, type, message, throwable);
        }

        public void error(Logger.EventType type, String message) {
            this.log(Level.SEVERE, type, message, null);
        }

        public void fatal(Logger.EventType type, String message, Throwable throwable) {
            this.log(Level.SEVERE, type, message, throwable);
        }

        public void fatal(Logger.EventType type, String message) {
            this.log(Level.SEVERE, type, message, null);
        }

        private void log(Level level, Logger.EventType type, String message, Throwable throwable) {
            if (!this.jlogger.isLoggable(level)) {
                return;
            }
            if (message == null) {
                message = "";
            }
            String clean = message.replace('\n', '_').replace('\r', '_');
            if (ESAPI.securityConfiguration().getLogEncodingRequired() && !message.equals(clean = ESAPI.encoder().encodeForHTML(message))) {
                clean = clean + " (Encoded)";
            }
            StringBuilder appInfo = new StringBuilder();
            if (ESAPI.currentRequest() != null && logServerIP) {
                appInfo.append(ESAPI.currentRequest().getLocalAddr() + ":" + ESAPI.currentRequest().getLocalPort());
            }
            if (logAppName) {
                appInfo.append("/" + this.applicationName);
            }
            appInfo.append("/" + this.moduleName);
            String typeInfo = "";
            if (type != null) {
                typeInfo = typeInfo + type + " ";
            }
            this.jlogger.log(level, "[" + typeInfo + this.getUserInfo() + " -> " + appInfo + "] " + clean, throwable);
        }

        public boolean isDebugEnabled() {
            return this.jlogger.isLoggable(Level.FINE);
        }

        public boolean isErrorEnabled() {
            return this.jlogger.isLoggable(JavaLoggerLevel.ERROR_LEVEL);
        }

        public boolean isFatalEnabled() {
            return this.jlogger.isLoggable(Level.SEVERE);
        }

        public boolean isInfoEnabled() {
            return this.jlogger.isLoggable(Level.INFO);
        }

        public boolean isTraceEnabled() {
            return this.jlogger.isLoggable(Level.FINEST);
        }

        public boolean isWarningEnabled() {
            return this.jlogger.isLoggable(Level.WARNING);
        }

        public String getUserInfo() {
            HttpSession session;
            String sid = null;
            HttpServletRequest request = ESAPI.httpUtilities().getCurrentRequest();
            if (request != null && (session = request.getSession(false)) != null && (sid = (String)session.getAttribute("ESAPI_SESSION")) == null) {
                sid = "" + ESAPI.randomizer().getRandomInteger(0, 1000000);
                session.setAttribute("ESAPI_SESSION", (Object)sid);
            }
            User user = ESAPI.authenticator().getCurrentUser();
            String userInfo = "";
            if (user != null) {
                userInfo = userInfo + user.getAccountName() + ":" + sid + "@" + user.getLastHostAddress();
            }
            return userInfo;
        }
    }

    public static class JavaLoggerLevel
    extends Level {
        protected static final long serialVersionUID = 1L;
        public static final Level ERROR_LEVEL = new JavaLoggerLevel("ERROR", Level.SEVERE.intValue() - 1);

        protected JavaLoggerLevel(String name, int value) {
            super(name, value);
        }
    }
}

