/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.LogFactory;
import org.owasp.esapi.Logger;
import org.owasp.esapi.User;

public class Log4JLogFactory
implements LogFactory {
    protected HashMap loggersMap = new HashMap();

    public Logger getLogger(Class clazz) {
        Logger classLogger = (Logger)this.loggersMap.get(clazz);
        if (classLogger == null) {
            classLogger = new Log4JLogger(clazz.getName());
            this.loggersMap.put(clazz, classLogger);
        }
        return classLogger;
    }

    public Logger getLogger(String moduleName) {
        Logger moduleLogger = (Logger)this.loggersMap.get(moduleName);
        if (moduleLogger == null) {
            moduleLogger = new Log4JLogger(moduleName);
            this.loggersMap.put(moduleName, moduleLogger);
        }
        return moduleLogger;
    }

    protected static class Log4JLogger
    implements Logger {
        private org.apache.log4j.Logger jlogger = null;
        private String moduleName = null;
        private String applicationName = ESAPI.securityConfiguration().getApplicationName();
        private static boolean logAppName = ESAPI.securityConfiguration().getLogApplicationName();
        private static boolean logServerIP = ESAPI.securityConfiguration().getLogServerIP();

        protected Log4JLogger(String moduleName) {
            this.moduleName = moduleName;
            this.jlogger = org.apache.log4j.Logger.getLogger((String)(this.applicationName + ":" + moduleName));
        }

        public void setLevel(int level) {
            try {
                this.jlogger.setLevel(Log4JLogger.convertESAPILeveltoLoggerLevel(level));
            }
            catch (IllegalArgumentException e) {
                this.error(Logger.SECURITY_FAILURE, "", e);
            }
        }

        private static Level convertESAPILeveltoLoggerLevel(int level) {
            switch (level) {
                case 0x7FFFFFFF: {
                    return Level.OFF;
                }
                case 1000: {
                    return Level.FATAL;
                }
                case 800: {
                    return Level.ERROR;
                }
                case 600: {
                    return Level.WARN;
                }
                case 400: {
                    return Level.INFO;
                }
                case 200: {
                    return Level.DEBUG;
                }
                case 100: {
                    return Level.TRACE;
                }
                case -2147483648: {
                    return Level.ALL;
                }
            }
            throw new IllegalArgumentException("Invalid logging level. Value was: " + level);
        }

        public void trace(Logger.EventType type, String message, Throwable throwable) {
            this.log(Level.TRACE, type, message, throwable);
        }

        public void trace(Logger.EventType type, String message) {
            this.log(Level.TRACE, type, message, null);
        }

        public void debug(Logger.EventType type, String message, Throwable throwable) {
            this.log(Level.DEBUG, type, message, throwable);
        }

        public void debug(Logger.EventType type, String message) {
            this.log(Level.DEBUG, type, message, null);
        }

        public void info(Logger.EventType type, String message) {
            this.log(Level.INFO, type, message, null);
        }

        public void info(Logger.EventType type, String message, Throwable throwable) {
            this.log(Level.INFO, type, message, throwable);
        }

        public void warning(Logger.EventType type, String message, Throwable throwable) {
            this.log(Level.WARN, type, message, throwable);
        }

        public void warning(Logger.EventType type, String message) {
            this.log(Level.WARN, type, message, null);
        }

        public void error(Logger.EventType type, String message, Throwable throwable) {
            this.log(Level.ERROR, type, message, throwable);
        }

        public void error(Logger.EventType type, String message) {
            this.log(Level.ERROR, type, message, null);
        }

        public void fatal(Logger.EventType type, String message, Throwable throwable) {
            this.log(Level.FATAL, type, message, throwable);
        }

        public void fatal(Logger.EventType type, String message) {
            this.log(Level.FATAL, type, message, null);
        }

        private void log(Level level, Logger.EventType type, String message, Throwable throwable) {
            if (!this.jlogger.isEnabledFor((Priority)level)) {
                return;
            }
            if (message == null) {
                message = "";
            }
            String clean = message.replace('\n', '_').replace('\r', '_');
            if (ESAPI.securityConfiguration().getLogEncodingRequired() && !message.equals(clean = ESAPI.encoder().encodeForHTML(message))) {
                clean = clean + " (Encoded)";
            }
            StringBuilder appInfo = new StringBuilder();
            if (ESAPI.currentRequest() != null && logServerIP) {
                appInfo.append(ESAPI.currentRequest().getLocalAddr() + ":" + ESAPI.currentRequest().getLocalPort());
            }
            if (logAppName) {
                appInfo.append("/" + this.applicationName);
            }
            appInfo.append("/" + this.moduleName);
            String typeInfo = "";
            if (type != null) {
                typeInfo = typeInfo + type + " ";
            }
            this.jlogger.log((Priority)level, (Object)("[" + typeInfo + this.getUserInfo() + " -> " + appInfo + "] " + clean), throwable);
        }

        public boolean isDebugEnabled() {
            return this.jlogger.isEnabledFor((Priority)Level.DEBUG);
        }

        public boolean isErrorEnabled() {
            return this.jlogger.isEnabledFor((Priority)Level.ERROR);
        }

        public boolean isFatalEnabled() {
            return this.jlogger.isEnabledFor((Priority)Level.FATAL);
        }

        public boolean isInfoEnabled() {
            return this.jlogger.isEnabledFor((Priority)Level.INFO);
        }

        public boolean isTraceEnabled() {
            return this.jlogger.isEnabledFor((Priority)Level.TRACE);
        }

        public boolean isWarningEnabled() {
            return this.jlogger.isEnabledFor((Priority)Level.WARN);
        }

        public String getUserInfo() {
            HttpSession session;
            String sid = null;
            HttpServletRequest request = ESAPI.httpUtilities().getCurrentRequest();
            if (request != null && (session = request.getSession(false)) != null && (sid = (String)session.getAttribute("ESAPI_SESSION")) == null) {
                sid = "" + ESAPI.randomizer().getRandomInteger(0, 1000000);
                session.setAttribute("ESAPI_SESSION", (Object)sid);
            }
            User user = ESAPI.authenticator().getCurrentUser();
            String userInfo = "";
            if (user != null) {
                userInfo = userInfo + user.getAccountName() + ":" + sid + "@" + user.getLastHostAddress();
            }
            return userInfo;
        }
    }
}

