/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.crypto;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Set;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.EncryptedProperties;
import org.owasp.esapi.Logger;
import org.owasp.esapi.crypto.CipherText;
import org.owasp.esapi.crypto.PlainText;
import org.owasp.esapi.errors.EncryptionException;

public class DefaultEncryptedProperties
implements EncryptedProperties {
    private final Properties properties = new Properties();
    private final Logger logger = ESAPI.getLogger("EncryptedProperties");

    public synchronized String getProperty(String key) throws EncryptionException {
        try {
            String encryptedValue = this.properties.getProperty(key);
            if (encryptedValue == null) {
                return null;
            }
            byte[] serializedCiphertext = ESAPI.encoder().decodeFromBase64(encryptedValue);
            CipherText restoredCipherText = CipherText.fromPortableSerializedBytes(serializedCiphertext);
            PlainText plaintext = ESAPI.encryptor().decrypt(restoredCipherText);
            return plaintext.toString();
        }
        catch (Exception e) {
            throw new EncryptionException("Property retrieval failure", "Couldn't decrypt property", e);
        }
    }

    public synchronized String setProperty(String key, String value) throws EncryptionException {
        try {
            if (key == null) {
                throw new NullPointerException("Property name may not be null.");
            }
            if (value == null) {
                throw new NullPointerException("Property value may not be null.");
            }
            PlainText pt = new PlainText(value);
            CipherText ct = ESAPI.encryptor().encrypt(pt);
            byte[] serializedCiphertext = ct.asPortableSerializedByteArray();
            String b64str = ESAPI.encoder().encodeForBase64(serializedCiphertext, false);
            return (String)this.properties.setProperty(key, b64str);
        }
        catch (Exception e) {
            throw new EncryptionException("Property setting failure", "Couldn't encrypt property", e);
        }
    }

    public Set keySet() {
        return this.properties.keySet();
    }

    public void load(InputStream in) throws IOException {
        this.properties.load(in);
        this.logger.trace(Logger.SECURITY_SUCCESS, "Encrypted properties loaded successfully");
    }

    public void store(OutputStream out, String comments) throws IOException {
        this.properties.store(out, comments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String value;
        File f = new File(args[0]);
        ESAPI.getLogger("EncryptedProperties.main").debug(Logger.SECURITY_SUCCESS, "Loading encrypted properties from " + f.getAbsolutePath());
        if (!f.exists()) {
            throw new IOException("Properties file not found: " + f.getAbsolutePath());
        }
        ESAPI.getLogger("EncryptedProperties.main").debug(Logger.SECURITY_SUCCESS, "Encrypted properties found in " + f.getAbsolutePath());
        DefaultEncryptedProperties ep = new DefaultEncryptedProperties();
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(f);
            out = new FileOutputStream(f);
            ep.load(in);
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            String key = null;
            do {
                System.out.print("Enter key: ");
                key = br.readLine();
                System.out.print("Enter value: ");
                value = br.readLine();
                if (key == null || key.length() <= 0 || value == null || value.length() <= 0) continue;
                ep.setProperty(key, value);
            } while (key != null && key.length() > 0);
            ep.store(out, "Encrypted Properties File");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {}
        }
        for (String k : ep.keySet()) {
            value = ep.getProperty(k);
            System.out.println("   " + k + "=" + value);
        }
    }
}

