/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.crypto;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.EncoderConstants;
import org.owasp.esapi.Encryptor;
import org.owasp.esapi.Logger;
import org.owasp.esapi.codecs.Hex;
import org.owasp.esapi.crypto.CipherSpec;
import org.owasp.esapi.crypto.CipherText;
import org.owasp.esapi.crypto.CryptoHelper;
import org.owasp.esapi.crypto.PlainText;
import org.owasp.esapi.crypto.SecurityProviderLoader;
import org.owasp.esapi.errors.ConfigurationException;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.errors.IntegrityException;

public final class JavaEncryptor
implements Encryptor {
    private static boolean initialized = false;
    private static SecretKeySpec secretKeySpec = null;
    private static String encryptAlgorithm = "AES";
    private static String encoding = "UTF-8";
    private static int encryptionKeyLength = 256;
    private static PrivateKey privateKey = null;
    private static PublicKey publicKey = null;
    private static String signatureAlgorithm = "SHAwithDSA";
    private static String randomAlgorithm = "SHA1PRNG";
    private static int signatureKeyLength = 1024;
    private static String hashAlgorithm = "SHA-512";
    private static int hashIterations = 1024;
    private static Logger logger = ESAPI.getLogger("JavaEncryptor");
    private static int encryptCounter = 0;
    private static int decryptCounter = 0;
    private static final int logEveryNthUse = 25;

    public static void main(String[] args) throws Exception {
        System.out.println("Generating a new secret master key");
        if (args.length == 1 && args[0].equalsIgnoreCase("-print")) {
            System.out.println("AVAILABLE ALGORITHMS");
            Provider[] providers = Security.getProviders();
            TreeMap<String, String> tm = new TreeMap<String, String>();
            for (int i = 0; i != providers.length; ++i) {
                System.out.println("===== Provider " + i + ":" + providers[i].getName() + " ======");
                for (String string : providers[i].keySet()) {
                    String value = providers[i].getProperty(string);
                    tm.put(string, value);
                    System.out.println("\t\t   " + string + " -> " + value);
                }
            }
            Set keyValueSet = tm.entrySet();
            for (Map.Entry entry : keyValueSet) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                System.out.println("   " + key + " -> " + value);
            }
        } else {
            System.out.println("\tuse '-print' to also show available crypto algorithms from all the security providers");
        }
        encryptAlgorithm = ESAPI.securityConfiguration().getEncryptionAlgorithm();
        encryptionKeyLength = ESAPI.securityConfiguration().getEncryptionKeyLength();
        randomAlgorithm = ESAPI.securityConfiguration().getRandomAlgorithm();
        SecureRandom random = SecureRandom.getInstance(randomAlgorithm);
        SecretKey secretKey = CryptoHelper.generateSecretKey(encryptAlgorithm, encryptionKeyLength);
        byte[] raw = secretKey.getEncoded();
        byte[] salt = new byte[20];
        random.nextBytes(salt);
        String string = System.getProperty("line.separator", "\n");
        System.out.println(string + "Copy and paste these lines into ESAPI.properties" + string);
        System.out.println("#==============================================================");
        System.out.println("Encryptor.MasterKey=" + ESAPI.encoder().encodeForBase64(raw, false));
        System.out.println("Encryptor.MasterSalt=" + ESAPI.encoder().encodeForBase64(salt, false));
        System.out.println("#==============================================================" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaEncryptor() throws EncryptionException {
        byte[] salt = ESAPI.securityConfiguration().getMasterSalt();
        byte[] skey = ESAPI.securityConfiguration().getMasterKey();
        assert (salt != null) : "Can't obtain master salt, Encryptor.MasterSalt";
        assert (salt.length >= 16) : "Encryptor.MasterSalt must be at least 16 bytes. Length is: " + salt.length + " bytes.";
        assert (skey != null) : "Can't obtain master key, Encryptor.MasterKey";
        assert (skey.length >= 7) : "Encryptor.MasterKey must be at least 7 bytes. Length is: " + skey.length + " bytes.";
        Class<JavaEncryptor> clazz = JavaEncryptor.class;
        synchronized (JavaEncryptor.class) {
            if (!initialized) {
                secretKeySpec = new SecretKeySpec(skey, encryptAlgorithm);
                try {
                    SecureRandom random = SecureRandom.getInstance(randomAlgorithm);
                    byte[] seed = this.hash(new String(skey, encoding), new String(salt, encoding)).getBytes(encoding);
                    random.setSeed(seed);
                    JavaEncryptor.initKeyPair(random);
                }
                catch (Exception e) {
                    throw new EncryptionException("Encryption failure", "Error creating Encryptor", e);
                }
                initialized = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public String hash(String plaintext, String salt) throws EncryptionException {
        return this.hash(plaintext, salt, hashIterations);
    }

    public String hash(String plaintext, String salt, int iterations) throws EncryptionException {
        byte[] bytes = null;
        try {
            MessageDigest digest = MessageDigest.getInstance(hashAlgorithm);
            digest.reset();
            digest.update(ESAPI.securityConfiguration().getMasterSalt());
            digest.update(salt.getBytes(encoding));
            digest.update(plaintext.getBytes(encoding));
            bytes = digest.digest();
            for (int i = 0; i < iterations; ++i) {
                digest.reset();
                bytes = digest.digest(bytes);
            }
            String encoded = ESAPI.encoder().encodeForBase64(bytes, false);
            return encoded;
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Internal error", "Can't find hash algorithm " + hashAlgorithm, e);
        }
        catch (UnsupportedEncodingException ex) {
            throw new EncryptionException("Internal error", "Can't find encoding for " + encoding, ex);
        }
    }

    @Deprecated
    public String encrypt(String plaintext) throws EncryptionException {
        this.logWarning("encrypt", "Calling deprecated encrypt() method.");
        CipherText ct = null;
        ct = this.encrypt(new PlainText(plaintext));
        return ct.getEncodedIVCipherText();
    }

    public CipherText encrypt(PlainText plaintext) throws EncryptionException {
        return this.encrypt(secretKeySpec, plaintext);
    }

    public CipherText encrypt(SecretKey key, PlainText plain) throws EncryptionException {
        byte[] plaintext = plain.asBytes();
        boolean overwritePlaintext = ESAPI.securityConfiguration().overwritePlainText();
        assert (key != null) : "(Master) encryption key may not be null";
        boolean success = false;
        String xform = null;
        int keySize = key.getEncoded().length * 8;
        try {
            String skeyAlg;
            xform = ESAPI.securityConfiguration().getCipherTransformation();
            String[] parts = xform.split("/");
            assert (parts.length == 3) : "Malformed cipher transformation: " + xform;
            String cipherMode = parts[1];
            if (!CryptoHelper.isAllowedCipherMode(cipherMode)) {
                throw new EncryptionException("Encryption failure: invalid cipher mode ( " + cipherMode + ") for encryption", "Encryption failure: Cipher transformation " + xform + " specifies invalid " + "cipher mode " + cipherMode);
            }
            Cipher encrypter = Cipher.getInstance(xform);
            String cipherAlg = encrypter.getAlgorithm();
            int keyLen = ESAPI.securityConfiguration().getEncryptionKeyLength();
            if (keySize != keyLen) {
                logger.warning(Logger.SECURITY_FAILURE, "Encryption key length mismatch. ESAPI.EncryptionKeyLength is " + keyLen + " bits, but length of actual encryption key is " + keySize + " bits.  Did you remember to regenerate your master key (if that is what you are using)???");
            }
            if (keySize < keyLen) {
                logger.warning(Logger.SECURITY_FAILURE, "Actual key size of " + keySize + " bits SMALLER THAN specified " + "encryption key length (ESAPI.EncryptionKeyLength) of " + keyLen + " bits with cipher algorithm " + cipherAlg);
            }
            if (keySize < 80) {
                logger.warning(Logger.SECURITY_FAILURE, "Potentially unsecure encryption. Key size of " + keySize + "bits " + "not sufficiently long for " + cipherAlg + ". Should use appropriate algorithm with key size " + "of *at least* 80 bits except when required by legacy apps.");
            }
            if (!cipherAlg.startsWith((skeyAlg = key.getAlgorithm()) + "/") && !cipherAlg.equals(skeyAlg)) {
                logger.warning(Logger.SECURITY_FAILURE, "Encryption mismatch between cipher algorithm (" + cipherAlg + ") and SecretKey algorithm (" + skeyAlg + "). Cipher will use algorithm " + cipherAlg);
            }
            byte[] ivBytes = null;
            CipherSpec cipherSpec = new CipherSpec(encrypter, keySize);
            boolean preferredCipherMode = CryptoHelper.isCombinedCipherMode(cipherMode);
            SecretKey encKey = null;
            encKey = preferredCipherMode ? key : CryptoHelper.computeDerivedKey(key, keySize, "encryption");
            if (cipherSpec.requiresIV()) {
                String ivType = ESAPI.securityConfiguration().getIVType();
                IvParameterSpec ivSpec = null;
                if (ivType.equalsIgnoreCase("random")) {
                    ivBytes = ESAPI.randomizer().getRandomBytes(encrypter.getBlockSize());
                } else if (ivType.equalsIgnoreCase("fixed")) {
                    String fixedIVAsHex = ESAPI.securityConfiguration().getFixedIV();
                    ivBytes = Hex.decode(fixedIVAsHex);
                } else {
                    throw new ConfigurationException("Property Encryptor.ChooseIVMethod must be set to 'random' or 'fixed'");
                }
                ivSpec = new IvParameterSpec(ivBytes);
                cipherSpec.setIV(ivBytes);
                encrypter.init(1, (Key)encKey, ivSpec);
            } else {
                encrypter.init(1, encKey);
            }
            logger.debug(Logger.EVENT_SUCCESS, "Encrypting with " + cipherSpec);
            byte[] raw = encrypter.doFinal(plaintext);
            CipherText ciphertext = new CipherText(cipherSpec, raw);
            if (!preferredCipherMode) {
                SecretKey authKey = CryptoHelper.computeDerivedKey(key, keySize, "authenticity");
                ciphertext.computeAndStoreMAC(authKey);
            }
            logger.debug(Logger.EVENT_SUCCESS, "JavaEncryptor.encrypt(SecretKey,byte[],boolean,boolean) -- success!");
            success = true;
            CipherText cipherText = ciphertext;
            return cipherText;
        }
        catch (InvalidKeyException ike) {
            throw new EncryptionException("Encryption failure: Invalid key exception.", "Requested key size: " + keySize + "bits greater than 128 bits. Must install unlimited strength crypto extension from Sun: " + ike.getMessage(), ike);
        }
        catch (ConfigurationException cex) {
            throw new EncryptionException("Encryption failure: Configuration error. Details in log.", "Key size mismatch or unsupported IV method. Check encryption key size vs. ESAPI.EncryptionKeyLength or Encryptor.ChooseIVMethod property.", cex);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EncryptionException("Encryption failure (invalid IV)", "Encryption problem: Invalid IV spec: " + e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptionException("Encryption failure (no padding used; invalid input size)", "Encryption problem: Invalid input size without padding (" + xform + "). " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new EncryptionException("Encryption failure", "[Note: Should NEVER happen in encryption mode.] Encryption problem: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Encryption failure (unavailable cipher requested)", "Encryption problem: specified algorithm in cipher xform " + xform + " not available: " + e.getMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException("Encryption failure (unavailable padding scheme requested)", "Encryption problem: specified padding scheme in cipher xform " + xform + " not available: " + e.getMessage(), e);
        }
        finally {
            if (success && overwritePlaintext) {
                plain.overwrite();
            }
        }
    }

    @Deprecated
    public String decrypt(String b64IVCiphertext) throws EncryptionException {
        this.logWarning("decrypt", "Calling deprecated decrypt() method.");
        CipherText ct = null;
        try {
            ct = new CipherText();
            byte[] ivPlusRawCipherText = ESAPI.encoder().decodeFromBase64(b64IVCiphertext);
            int blockSize = ct.getBlockSize();
            byte[] iv = new byte[blockSize];
            CryptoHelper.copyByteArray(ivPlusRawCipherText, iv, blockSize);
            int cipherTextSize = ivPlusRawCipherText.length - blockSize;
            byte[] rawCipherText = new byte[cipherTextSize];
            System.arraycopy(ivPlusRawCipherText, blockSize, rawCipherText, 0, cipherTextSize);
            ct.setIVandCiphertext(iv, rawCipherText);
            PlainText plaintext = this.decrypt(ct);
            return plaintext.toString();
        }
        catch (UnsupportedEncodingException e) {
            logger.error(Logger.SECURITY_FAILURE, "UTF-8 encoding not available! Decryption failed.", e);
            return null;
        }
        catch (IOException e) {
            logger.error(Logger.SECURITY_FAILURE, "Base64 decoding of IV+ciphertext failed. Decryption failed.", e);
            return null;
        }
    }

    public PlainText decrypt(CipherText ciphertext) throws EncryptionException {
        return this.decrypt(secretKeySpec, ciphertext);
    }

    public PlainText decrypt(SecretKey key, CipherText ciphertext) throws EncryptionException {
        SecretKey authKey = null;
        try {
            assert (key != null) : "Encryption key may not be null";
            assert (ciphertext != null) : "Ciphertext may not be null";
            if (!CryptoHelper.isAllowedCipherMode(ciphertext.getCipherMode())) {
                throw new EncryptionException("Decryption failed -- invalid cipher mode", "Cipher mode " + ciphertext.getCipherMode() + " not permitted for decryption or encryption operations.");
            }
            logger.debug(Logger.EVENT_SUCCESS, "JavaEncryptor.decrypt(SecretKey,CipherText): " + ciphertext);
            Cipher decrypter = Cipher.getInstance(ciphertext.getCipherTransformation());
            int keySize = key.getEncoded().length * 8;
            boolean preferredCipherMode = CryptoHelper.isCombinedCipherMode(ciphertext.getCipherMode());
            SecretKey encKey = null;
            encKey = preferredCipherMode ? key : CryptoHelper.computeDerivedKey(key, keySize, "encryption");
            if (ciphertext.requiresIV()) {
                decrypter.init(2, (Key)encKey, new IvParameterSpec(ciphertext.getIV()));
            } else {
                decrypter.init(2, encKey);
            }
            byte[] output = decrypter.doFinal(ciphertext.getRawCipherText());
            if (preferredCipherMode) {
                return new PlainText(output);
            }
            authKey = CryptoHelper.computeDerivedKey(key, keySize, "authenticity");
            boolean success = ciphertext.validateMAC(authKey);
            if (!success) {
                throw new EncryptionException("Decryption verification failed.", "Decryption returned without throwing but MAC verification failed, meaning returned plaintext was garbarge or ciphertext not authentic.");
            }
            return new PlainText(output);
        }
        catch (InvalidKeyException ike) {
            throw new EncryptionException("Decryption failure", "Must install unlimited strength crypto extension from Sun", ike);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Decryption failed", "Invalid algorithm for available JCE providers - " + ciphertext.getCipherTransformation() + ": " + e.getMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException("Decryption failed", "Invalid padding scheme (" + ciphertext.getPaddingScheme() + ") for cipher transformation " + ciphertext.getCipherTransformation() + ": " + e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EncryptionException("Decryption failed", "Decryption problem: " + e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptionException("Decryption failed", "Decryption problem: " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            boolean success = ciphertext.validateMAC(authKey);
            if (success) {
                throw new EncryptionException("Decryption failed", "Decryption problem: " + e.getMessage(), e);
            }
            throw new EncryptionException("Decryption failed", "Decryption problem: WARNING: Adversary may have tampered with CipherText object orCipherText object mangled in transit: " + e.getMessage(), e);
        }
    }

    public String sign(String data) throws EncryptionException {
        try {
            Signature signer = Signature.getInstance(signatureAlgorithm);
            signer.initSign(privateKey);
            signer.update(data.getBytes(encoding));
            byte[] bytes = signer.sign();
            return ESAPI.encoder().encodeForBase64(bytes, false);
        }
        catch (InvalidKeyException ike) {
            throw new EncryptionException("Encryption failure", "Must install unlimited strength crypto extension from Sun", ike);
        }
        catch (Exception e) {
            throw new EncryptionException("Signature failure", "Can't find signature algorithm " + signatureAlgorithm, e);
        }
    }

    public boolean verifySignature(String signature, String data) {
        try {
            byte[] bytes = ESAPI.encoder().decodeFromBase64(signature);
            Signature signer = Signature.getInstance(signatureAlgorithm);
            signer.initVerify(publicKey);
            signer.update(data.getBytes(encoding));
            return signer.verify(bytes);
        }
        catch (Exception e) {
            new EncryptionException("Invalid signature", "Problem verifying signature: " + e.getMessage(), e);
            return false;
        }
    }

    public String seal(String data, long expiration) throws IntegrityException {
        try {
            String random = ESAPI.randomizer().getRandomString(10, EncoderConstants.CHAR_ALPHANUMERICS);
            String plaintext = expiration + ":" + random + ":" + data;
            String sig = this.sign(plaintext);
            String ciphertext = this.encrypt(plaintext + ":" + sig);
            return ciphertext;
        }
        catch (EncryptionException e) {
            throw new IntegrityException(e.getUserMessage(), e.getLogMessage(), e);
        }
    }

    public String unseal(String seal) throws EncryptionException {
        String plaintext = null;
        try {
            long expiration;
            plaintext = this.decrypt(seal);
            String[] parts = plaintext.split(":");
            if (parts.length != 4) {
                throw new EncryptionException("Invalid seal", "Seal was not formatted properly");
            }
            String timestring = parts[0];
            long now = new Date().getTime();
            if (now > (expiration = Long.parseLong(timestring))) {
                throw new EncryptionException("Invalid seal", "Seal expiration date has expired");
            }
            String random = parts[1];
            String data = parts[2];
            String sig = parts[3];
            if (!this.verifySignature(sig, timestring + ":" + random + ":" + data)) {
                throw new EncryptionException("Invalid seal", "Seal integrity check failed");
            }
            return data;
        }
        catch (EncryptionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EncryptionException("Invalid seal", "Invalid seal:" + e.getMessage(), e);
        }
    }

    public boolean verifySeal(String seal) {
        try {
            this.unseal(seal);
            return true;
        }
        catch (EncryptionException e) {
            return false;
        }
    }

    public long getTimeStamp() {
        return new Date().getTime();
    }

    public long getRelativeTimeStamp(long offset) {
        return new Date().getTime() + offset;
    }

    private void logWarning(String where, String msg) {
        int counter = 0;
        if (where.equals("encrypt")) {
            counter = encryptCounter++;
            where = "JavaEncryptor.encrypt(): [count=" + counter + "]";
        } else if (where.equals("decrypt")) {
            counter = decryptCounter++;
            where = "JavaEncryptor.decrypt(): [count=" + counter + "]";
        } else {
            where = "JavaEncryptor: Unknown method: ";
        }
        if (counter % 25 == 0) {
            logger.warning(Logger.SECURITY_FAILURE, where + msg);
        }
    }

    private static void setupAlgorithms() {
        encryptAlgorithm = ESAPI.securityConfiguration().getEncryptionAlgorithm();
        signatureAlgorithm = ESAPI.securityConfiguration().getDigitalSignatureAlgorithm();
        randomAlgorithm = ESAPI.securityConfiguration().getRandomAlgorithm();
        hashAlgorithm = ESAPI.securityConfiguration().getHashAlgorithm();
        hashIterations = ESAPI.securityConfiguration().getHashIterations();
        encoding = ESAPI.securityConfiguration().getCharacterEncoding();
        encryptionKeyLength = ESAPI.securityConfiguration().getEncryptionKeyLength();
        signatureKeyLength = ESAPI.securityConfiguration().getDigitalSignatureKeyLength();
    }

    private static void initKeyPair(SecureRandom prng) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(signatureAlgorithm);
        keyGen.initialize(signatureKeyLength, prng);
        KeyPair pair = keyGen.generateKeyPair();
        privateKey = pair.getPrivate();
        publicKey = pair.getPublic();
    }

    static {
        try {
            SecurityProviderLoader.loadESAPIPreferredJCEProvider();
        }
        catch (NoSuchProviderException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        JavaEncryptor.setupAlgorithms();
    }
}

