/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.util;

import org.owasp.esapi.errors.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjFactory<T> {
    public T make(String className, String typeName) throws ConfigurationException {
        T obj = null;
        String errMsg = null;
        try {
            if (null == className || "".equals(className)) {
                throw new IllegalArgumentException("Classname cannot be null or empty.");
            }
            if (null == typeName || "".equals(typeName)) {
                typeName = "[unknown?]";
            }
            Class<?> theClass = Class.forName(className);
            obj = (T)theClass.newInstance();
            return obj;
        }
        catch (IllegalArgumentException ex) {
            errMsg = ex.toString() + " " + typeName + " type name cannot be null or empty.";
            throw new ConfigurationException(errMsg, ex);
        }
        catch (ClassNotFoundException ex) {
            errMsg = ex.toString() + " " + typeName + " class (" + className + ") must be in class path.";
            throw new ConfigurationException(errMsg, ex);
        }
        catch (InstantiationException ex) {
            errMsg = ex.toString() + " " + typeName + " class (" + className + ") must be concrete.";
            throw new ConfigurationException(errMsg, ex);
        }
        catch (IllegalAccessException ex) {
            errMsg = ex.toString() + " " + typeName + " class (" + className + ") must have a public, no-arg constructor.";
            throw new ConfigurationException(errMsg, ex);
        }
        catch (ClassCastException ex) {
            errMsg = ex.toString() + " " + typeName + " class (" + className + ") must be a subtype of T in ObjFactory<T>";
            throw new ConfigurationException(errMsg, ex);
        }
        catch (Exception ex) {
            errMsg = ex.toString() + " " + typeName + " class (" + className + ") CTOR threw exception.";
            throw new ConfigurationException(errMsg, ex);
        }
    }
}

