/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.waf.configuration;

import bsh.EvalError;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;
import nu.xom.ValidityException;
import org.apache.log4j.Level;
import org.owasp.esapi.waf.ConfigurationException;
import org.owasp.esapi.waf.configuration.AppGuardianConfiguration;
import org.owasp.esapi.waf.rules.AddHTTPOnlyFlagRule;
import org.owasp.esapi.waf.rules.AddHeaderRule;
import org.owasp.esapi.waf.rules.AddSecureFlagRule;
import org.owasp.esapi.waf.rules.AuthenticatedRule;
import org.owasp.esapi.waf.rules.BeanShellRule;
import org.owasp.esapi.waf.rules.DetectOutboundContentRule;
import org.owasp.esapi.waf.rules.EnforceHTTPSRule;
import org.owasp.esapi.waf.rules.HTTPMethodRule;
import org.owasp.esapi.waf.rules.IPRule;
import org.owasp.esapi.waf.rules.MustMatchRule;
import org.owasp.esapi.waf.rules.PathExtensionRule;
import org.owasp.esapi.waf.rules.ReplaceContentRule;
import org.owasp.esapi.waf.rules.RestrictContentTypeRule;
import org.owasp.esapi.waf.rules.RestrictUserAgentRule;
import org.owasp.esapi.waf.rules.SimpleVirtualPatchRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationParser {
    private static final String REGEX = "regex";
    private static final String DEFAULT_PATH_APPLY_ALL = ".*";
    private static final int DEFAULT_RESPONSE_CODE = 403;
    private static final String DEFAULT_SESSION_COOKIE = "JSESSIONID";
    private static final String[] STAGES = new String[]{"before-request-body", "after-request-body", "before-response"};

    public static AppGuardianConfiguration readConfigurationFile(InputStream stream, String webRootDir) throws ConfigurationException {
        AppGuardianConfiguration config;
        block71: {
            config = new AppGuardianConfiguration();
            Builder parser = new Builder();
            try {
                String pattern;
                String id;
                String path;
                String id2;
                String deny;
                String allow;
                Element e;
                String id3;
                String variable;
                Object path2;
                Element loggingRoot;
                String value;
                Document doc = parser.build(stream);
                Element root = doc.getRootElement();
                Element aliasesRoot = root.getFirstChildElement("aliases");
                Element settingsRoot = root.getFirstChildElement("settings");
                Element authNRoot = root.getFirstChildElement("authentication-rules");
                Element authZRoot = root.getFirstChildElement("authorization-rules");
                Element urlRoot = root.getFirstChildElement("url-rules");
                Element headerRoot = root.getFirstChildElement("header-rules");
                Element customRulesRoot = root.getFirstChildElement("custom-rules");
                Element virtualPatchesRoot = root.getFirstChildElement("virtual-patches");
                Element outboundRoot = root.getFirstChildElement("outbound-rules");
                Element beanShellRoot = root.getFirstChildElement("bean-shell-rules");
                if (aliasesRoot != null) {
                    Elements aliases = aliasesRoot.getChildElements("alias");
                    for (int i = 0; i < aliases.size(); ++i) {
                        Element e2 = aliases.get(i);
                        String name = e2.getAttributeValue("name");
                        String type = e2.getAttributeValue("type");
                        value = e2.getValue();
                        if (REGEX.equals(type)) {
                            config.addAlias(name, Pattern.compile(value));
                            continue;
                        }
                        config.addAlias(name, value);
                    }
                }
                if (settingsRoot == null) {
                    throw new ConfigurationException("The <settings> section is required");
                }
                if (settingsRoot != null) {
                    try {
                        String sessionCookieName = settingsRoot.getFirstChildElement("session-cookie-name").getValue();
                        if (!"".equals(sessionCookieName)) {
                            config.setSessionCookieName(sessionCookieName);
                        }
                    }
                    catch (NullPointerException npe) {
                        config.setSessionCookieName(DEFAULT_SESSION_COOKIE);
                    }
                    String mode = settingsRoot.getFirstChildElement("mode").getValue();
                    AppGuardianConfiguration.DEFAULT_FAIL_ACTION = "block".equals(mode.toLowerCase()) ? 2 : ("redirect".equals(mode.toLowerCase()) ? 1 : 0);
                    Element errorHandlingRoot = settingsRoot.getFirstChildElement("error-handling");
                    config.setDefaultErrorPage(errorHandlingRoot.getFirstChildElement("default-redirect-page").getValue());
                    try {
                        config.setDefaultResponseCode(Integer.parseInt(errorHandlingRoot.getFirstChildElement("block-status").getValue()));
                    }
                    catch (Exception e3) {
                        config.setDefaultResponseCode(403);
                    }
                }
                if ((loggingRoot = settingsRoot.getFirstChildElement("logging")) != null) {
                    config.setLogDirectory(loggingRoot.getFirstChildElement("log-directory").getValue());
                    config.setLogLevel(Level.toLevel((String)loggingRoot.getFirstChildElement("log-level").getValue()));
                }
                if (authNRoot != null) {
                    String key = authNRoot.getAttributeValue("key");
                    String path3 = authNRoot.getAttributeValue("path");
                    String id4 = authNRoot.getAttributeValue("id");
                    if (path3 != null && key != null) {
                        config.addBeforeBodyRule(new AuthenticatedRule(id4, key, Pattern.compile(path3), ConfigurationParser.getExceptionsFromElement(authNRoot)));
                    } else if (key != null) {
                        config.addBeforeBodyRule(new AuthenticatedRule(id4, key, null, ConfigurationParser.getExceptionsFromElement(authNRoot)));
                    } else {
                        throw new ConfigurationException("The <authentication-rules> rule requires a 'key' attribute");
                    }
                }
                if (authZRoot != null) {
                    Elements restrictNodes = authZRoot.getChildElements("restrict-source-ip");
                    for (int i = 0; i < restrictNodes.size(); ++i) {
                        Element restrictNodeRoot = restrictNodes.get(i);
                        String id5 = restrictNodeRoot.getAttributeValue("id");
                        Pattern ips = Pattern.compile(restrictNodeRoot.getAttributeValue("ip-regex"));
                        String ipHeader = restrictNodeRoot.getAttributeValue("ip-header");
                        if (REGEX.equalsIgnoreCase(restrictNodeRoot.getAttributeValue("type"))) {
                            config.addBeforeBodyRule(new IPRule(id5, ips, Pattern.compile(restrictNodeRoot.getValue()), ipHeader));
                            continue;
                        }
                        config.addBeforeBodyRule(new IPRule(id5, ips, restrictNodeRoot.getValue()));
                    }
                    Elements mustMatchNodes = authZRoot.getChildElements("must-match");
                    for (int i = 0; i < mustMatchNodes.size(); ++i) {
                        Element e4 = mustMatchNodes.get(i);
                        path2 = Pattern.compile(e4.getAttributeValue("path"));
                        variable = e4.getAttributeValue("variable");
                        String value2 = e4.getAttributeValue("value");
                        String operator = e4.getAttributeValue("operator");
                        id3 = e4.getAttributeValue("id");
                        int op = 0;
                        if ("exists".equalsIgnoreCase(operator)) {
                            op = 3;
                        } else if ("inList".equalsIgnoreCase(operator)) {
                            op = 2;
                        } else if ("contains".equalsIgnoreCase(operator)) {
                            op = 1;
                        }
                        config.addAfterBodyRule(new MustMatchRule(id3, (Pattern)path2, variable, op, value2));
                    }
                }
                if (urlRoot != null) {
                    int i;
                    Elements restrictExtensionNodes = urlRoot.getChildElements("restrict-extension");
                    Elements restrictMethodNodes = urlRoot.getChildElements("restrict-method");
                    Elements enforceHttpsNodes = urlRoot.getChildElements("enforce-https");
                    for (i = 0; i < restrictExtensionNodes.size(); ++i) {
                        e = restrictExtensionNodes.get(i);
                        allow = e.getAttributeValue("allow");
                        deny = e.getAttributeValue("deny");
                        id2 = e.getAttributeValue("id");
                        if (allow != null && deny != null) {
                            throw new ConfigurationException("restrict-extension rules can't have both 'allow' and 'deny'");
                        }
                        if (allow != null) {
                            config.addBeforeBodyRule(new PathExtensionRule(id2, Pattern.compile(".*\\" + allow + "$"), null));
                            continue;
                        }
                        if (deny != null) {
                            config.addBeforeBodyRule(new PathExtensionRule(id2, null, Pattern.compile(".*\\" + deny + "$")));
                            continue;
                        }
                        throw new ConfigurationException("restrict extension rule should have either a 'deny' or 'allow' attribute");
                    }
                    for (i = 0; i < restrictMethodNodes.size(); ++i) {
                        e = restrictMethodNodes.get(i);
                        allow = e.getAttributeValue("allow");
                        deny = e.getAttributeValue("deny");
                        String path4 = e.getAttributeValue("path");
                        id3 = e.getAttributeValue("id");
                        if (path4 == null) {
                            path4 = DEFAULT_PATH_APPLY_ALL;
                        }
                        if (allow != null && deny != null) {
                            throw new ConfigurationException("restrict-method rule should not have both 'allow' and 'deny' values");
                        }
                        if (allow != null) {
                            config.addBeforeBodyRule(new HTTPMethodRule(id3, Pattern.compile(allow), null, Pattern.compile(path4)));
                            continue;
                        }
                        if (deny != null) {
                            config.addBeforeBodyRule(new HTTPMethodRule(id3, null, Pattern.compile(deny), Pattern.compile(path4)));
                            continue;
                        }
                        throw new ConfigurationException("restrict-method rule should have either an 'allow' or 'deny' value");
                    }
                    for (i = 0; i < enforceHttpsNodes.size(); ++i) {
                        e = enforceHttpsNodes.get(i);
                        path = e.getAttributeValue("path");
                        String action = e.getAttributeValue("action");
                        id2 = e.getAttributeValue("id");
                        List<Object> exceptions = ConfigurationParser.getExceptionsFromElement(e);
                        config.addBeforeBodyRule(new EnforceHTTPSRule(id2, Pattern.compile(path), exceptions, action));
                    }
                }
                if (headerRoot != null) {
                    int i;
                    Elements restrictContentTypes = headerRoot.getChildElements("restrict-content-type");
                    Elements restrictUserAgents = headerRoot.getChildElements("restrict-user-agent");
                    for (i = 0; i < restrictContentTypes.size(); ++i) {
                        Element e5 = restrictContentTypes.get(i);
                        String allow2 = e5.getAttributeValue("allow");
                        String deny2 = e5.getAttributeValue("deny");
                        id = e5.getAttributeValue("id");
                        if (allow2 != null && deny2 != null) {
                            throw new ConfigurationException("restrict-content-type rule should not have both 'allow' and 'deny' values");
                        }
                        if (allow2 != null) {
                            config.addBeforeBodyRule(new RestrictContentTypeRule(id, Pattern.compile(allow2), null));
                            continue;
                        }
                        if (deny2 != null) {
                            config.addBeforeBodyRule(new RestrictContentTypeRule(id, null, Pattern.compile(deny2)));
                            continue;
                        }
                        throw new ConfigurationException("restrict-content-type rule should have either an 'allow' or 'deny' value");
                    }
                    for (i = 0; i < restrictUserAgents.size(); ++i) {
                        Element e6 = restrictUserAgents.get(i);
                        String id6 = e6.getAttributeValue("id");
                        allow = e6.getAttributeValue("allow");
                        deny = e6.getAttributeValue("deny");
                        if (allow != null && deny != null) {
                            throw new ConfigurationException("restrict-user-agent rule should not have both 'allow' and 'deny' values");
                        }
                        if (allow != null) {
                            config.addBeforeBodyRule(new RestrictUserAgentRule(id6, Pattern.compile(allow), null));
                            continue;
                        }
                        if (deny != null) {
                            config.addBeforeBodyRule(new RestrictUserAgentRule(id6, null, Pattern.compile(deny)));
                            continue;
                        }
                        throw new ConfigurationException("restrict-user-agent rule should have either an 'allow' or 'deny' value");
                    }
                }
                if (virtualPatchesRoot != null) {
                    Elements virtualPatchNodes = virtualPatchesRoot.getChildElements("virtual-patch");
                    for (int i = 0; i < virtualPatchNodes.size(); ++i) {
                        Element e7 = virtualPatchNodes.get(i);
                        String id7 = e7.getAttributeValue("id");
                        path2 = e7.getAttributeValue("path");
                        variable = e7.getAttributeValue("variable");
                        pattern = e7.getAttributeValue("pattern");
                        String message = e7.getAttributeValue("message");
                        config.addAfterBodyRule(new SimpleVirtualPatchRule(id7, Pattern.compile((String)path2), variable, Pattern.compile(pattern), message));
                    }
                }
                if (outboundRoot != null) {
                    String contentType;
                    String id8;
                    Elements addHeaderNodes = outboundRoot.getChildElements("add-header");
                    for (int i = 0; i < addHeaderNodes.size(); ++i) {
                        Element e8 = addHeaderNodes.get(i);
                        String name = e8.getAttributeValue("name");
                        value = e8.getAttributeValue("value");
                        path = e8.getAttributeValue("path");
                        id = e8.getAttributeValue("id");
                        if (path == null) {
                            path = DEFAULT_PATH_APPLY_ALL;
                        }
                        AddHeaderRule ahr = new AddHeaderRule(id, name, value, Pattern.compile(path), ConfigurationParser.getExceptionsFromElement(e8));
                        config.addBeforeResponseRule(ahr);
                    }
                    Elements addHTTPOnlyFlagNodes = outboundRoot.getChildElements("add-http-only-flag");
                    for (int i = 0; i < addHTTPOnlyFlagNodes.size(); ++i) {
                        Element e9 = addHTTPOnlyFlagNodes.get(i);
                        Elements cookiePatterns = e9.getChildElements("cookie");
                        id8 = e9.getAttributeValue("id");
                        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                        for (int j = 0; j < cookiePatterns.size(); ++j) {
                            Element cookie = cookiePatterns.get(j);
                            patterns.add(Pattern.compile(cookie.getAttributeValue("name")));
                        }
                        AddHTTPOnlyFlagRule ahfr = new AddHTTPOnlyFlagRule(id8, patterns);
                        config.addCookieRule(ahfr);
                        if (!ahfr.doesCookieMatch(config.getSessionCookieName())) continue;
                        config.setApplyHTTPOnlyFlagToSessionCookie(true);
                    }
                    Elements addSecureFlagNodes = outboundRoot.getChildElements("add-secure-flag");
                    for (int i = 0; i < addSecureFlagNodes.size(); ++i) {
                        e = addSecureFlagNodes.get(i);
                        id8 = e.getAttributeValue("id");
                        Elements cookiePatterns = e.getChildElements("cookie");
                        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                        for (int j = 0; j < cookiePatterns.size(); ++j) {
                            Element cookie = cookiePatterns.get(j);
                            patterns.add(Pattern.compile(cookie.getAttributeValue("name")));
                        }
                        AddSecureFlagRule asfr = new AddSecureFlagRule(id8, patterns);
                        config.addCookieRule(asfr);
                        if (!asfr.doesCookieMatch(config.getSessionCookieName())) continue;
                        config.setApplySecureFlagToSessionCookie(true);
                    }
                    Elements dynamicInsertionNodes = outboundRoot.getChildElements("dynamic-insertion");
                    for (int i = 0; i < dynamicInsertionNodes.size(); ++i) {
                        Element e10 = dynamicInsertionNodes.get(i);
                        pattern = e10.getAttributeValue("pattern");
                        id2 = e10.getAttributeValue("id");
                        contentType = e10.getAttributeValue("content-type");
                        String urlPaths = e10.getAttributeValue("path");
                        Element replacement = e10.getFirstChildElement("replacement");
                        ReplaceContentRule rcr = new ReplaceContentRule(id2, Pattern.compile(pattern, 32), replacement.getValue(), contentType != null ? Pattern.compile(contentType) : null, urlPaths != null ? Pattern.compile(urlPaths) : null);
                        config.addBeforeResponseRule(rcr);
                    }
                    Elements detectContentNodes = outboundRoot.getChildElements("detect-content");
                    for (int i = 0; i < detectContentNodes.size(); ++i) {
                        Element e11 = detectContentNodes.get(i);
                        String token = e11.getAttributeValue("pattern");
                        contentType = e11.getAttributeValue("content-type");
                        String id9 = e11.getAttributeValue("id");
                        String path5 = e11.getAttributeValue("path");
                        if (token == null) {
                            throw new ConfigurationException("<detect-content> rules must contain a 'pattern' attribute");
                        }
                        if (contentType == null) {
                            throw new ConfigurationException("<detect-content> rules must contain a 'content-type' attribute");
                        }
                        DetectOutboundContentRule docr = new DetectOutboundContentRule(id9, Pattern.compile(contentType), Pattern.compile(token, 32), path5 != null ? Pattern.compile(path5) : null);
                        config.addBeforeResponseRule(docr);
                    }
                }
                if (beanShellRoot == null) break block71;
                Elements beanShellRules = beanShellRoot.getChildElements("bean-shell-script");
                for (int i = 0; i < beanShellRules.size(); ++i) {
                    Element e12 = beanShellRules.get(i);
                    String id10 = e12.getAttributeValue("id");
                    String fileName = e12.getAttributeValue("file");
                    String stage = e12.getAttributeValue("stage");
                    String path6 = e12.getAttributeValue("path");
                    if (id10 == null) {
                        throw new ConfigurationException("bean shell rules all require a unique 'id' attribute");
                    }
                    if (fileName == null) {
                        throw new ConfigurationException("bean shell rules all require a unique 'file' attribute that has the location of the .bsh script");
                    }
                    try {
                        BeanShellRule bsr = new BeanShellRule(webRootDir + fileName, id10, path6 != null ? Pattern.compile(path6) : null);
                        if (STAGES[0].equals(stage)) {
                            config.addBeforeBodyRule(bsr);
                            continue;
                        }
                        if (STAGES[1].equals(stage)) {
                            config.addAfterBodyRule(bsr);
                            continue;
                        }
                        if (STAGES[2].equals(stage)) {
                            config.addBeforeResponseRule(bsr);
                            continue;
                        }
                        throw new ConfigurationException("bean shell rules all require a 'stage' attribute when the rule should be fired (valid values are " + STAGES[0] + ", " + STAGES[1] + ", or " + STAGES[2] + ")");
                    }
                    catch (FileNotFoundException fnfe) {
                        throw new ConfigurationException("bean shell rule '" + id10 + "' had a source file that could not be found (" + fileName + "), web directory = " + webRootDir);
                    }
                    catch (EvalError ee) {
                        throw new ConfigurationException("bean shell rule '" + id10 + "' contained an error (" + ee.getErrorText() + "): " + ee.getScriptStackTrace());
                    }
                }
            }
            catch (ValidityException e) {
                throw new ConfigurationException((Exception)((Object)e));
            }
            catch (ParsingException e) {
                throw new ConfigurationException((Exception)((Object)e));
            }
            catch (IOException e) {
                throw new ConfigurationException(e);
            }
        }
        return config;
    }

    private static List<Object> getExceptionsFromElement(Element root) {
        Elements exceptions = root.getChildElements("path-exception");
        ArrayList<Object> exceptionList = new ArrayList<Object>();
        for (int i = 0; i < exceptions.size(); ++i) {
            Element e = exceptions.get(i);
            if (REGEX.equalsIgnoreCase(e.getAttributeValue("type"))) {
                exceptionList.add(Pattern.compile(e.getValue()));
                continue;
            }
            exceptionList.add(e.getValue());
        }
        return exceptionList;
    }
}

