/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.hive;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class HiveTypes {
    public static final Log LOG = LogFactory.getLog((String)HiveTypes.class.getName());

    private HiveTypes() {
    }

    public static String toHiveType(int sqlType) {
        switch (sqlType) {
            case 4: 
            case 5: {
                return "INT";
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2005: {
                return "STRING";
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return "DOUBLE";
            }
            case -7: 
            case 16: {
                return "BOOLEAN";
            }
            case -6: {
                return "TINYINT";
            }
            case -5: {
                return "BIGINT";
            }
        }
        return null;
    }

    public static boolean isHiveTypeImprovised(int sqlType) {
        return sqlType == 91 || sqlType == 92 || sqlType == 93 || sqlType == 3 || sqlType == 2;
    }
}

