/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.io;

import com.cloudera.sqoop.io.LobFile;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public final class LobReaderCache {
    public static final Log LOG = LogFactory.getLog((String)LobReaderCache.class.getName());
    private Map<Path, LobFile.Reader> readerMap = new TreeMap<Path, LobFile.Reader>();
    private static final LobReaderCache CACHE = new LobReaderCache();

    private LobReaderCache() {
    }

    public static LobReaderCache getCache() {
        return CACHE;
    }

    public static Path qualify(Path path, Configuration conf) throws IOException {
        if (null == path) {
            return null;
        }
        FileSystem fs = path.getFileSystem(conf);
        if (null == fs) {
            fs = FileSystem.get((Configuration)conf);
        }
        return path.makeQualified(fs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LobFile.Reader get(Path path, Configuration conf) throws IOException {
        LobFile.Reader reader = null;
        Path canonicalPath = LobReaderCache.qualify(path, conf);
        LobReaderCache lobReaderCache = this;
        synchronized (lobReaderCache) {
            reader = this.readerMap.remove(canonicalPath);
        }
        if (null != reader && !reader.isClosed()) {
            LOG.debug((Object)("Using cached reader for " + canonicalPath));
            return reader;
        }
        LOG.debug((Object)("No cached reader available for " + canonicalPath));
        return LobFile.open(path, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle(LobFile.Reader reader) throws IOException {
        Path canonicalPath = reader.getPath();
        boolean cached = false;
        LobReaderCache lobReaderCache = this;
        synchronized (lobReaderCache) {
            if (this.readerMap.get(canonicalPath) == null) {
                LOG.debug((Object)("Caching reader for path: " + canonicalPath));
                this.readerMap.put(canonicalPath, reader);
                cached = true;
            }
        }
        if (!cached) {
            LOG.debug((Object)("Reader already present for path: " + canonicalPath + "; closing."));
            reader.close();
        }
    }

    protected synchronized void finalize() throws Throwable {
        for (LobFile.Reader r : this.readerMap.values()) {
            r.close();
        }
        super.finalize();
    }
}

