/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.lib;

import com.cloudera.sqoop.io.LobFile;
import com.cloudera.sqoop.lib.LobRef;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;

public class BlobRef
extends LobRef<byte[], BytesWritable, InputStream> {
    public static final Log LOG = LogFactory.getLog((String)BlobRef.class.getName());

    public BlobRef() {
    }

    public BlobRef(byte[] bytes) {
        super(new BytesWritable(bytes));
    }

    public BlobRef(String file, long offset, long length) {
        super(file, offset, length);
    }

    @Override
    protected InputStream getExternalSource(LobFile.Reader reader) throws IOException {
        return reader.readBlobRecord();
    }

    @Override
    protected InputStream getInternalSource(BytesWritable data) {
        return new ByteArrayInputStream(data.getBytes(), 0, data.getLength());
    }

    @Override
    protected byte[] getInternalData(BytesWritable data) {
        return Arrays.copyOf(data.getBytes(), data.getLength());
    }

    @Override
    protected BytesWritable deepCopyData(BytesWritable data) {
        return new BytesWritable(Arrays.copyOf(data.getBytes(), data.getLength()));
    }

    @Override
    public void readFieldsInternal(DataInput in) throws IOException {
        BytesWritable data = (BytesWritable)this.getDataObj();
        if (null == data) {
            data = new BytesWritable();
        }
        data.readFields(in);
        this.setDataObj(data);
    }

    @Override
    public void writeInternal(DataOutput out) throws IOException {
        ((BytesWritable)this.getDataObj()).write(out);
    }

    public static BlobRef parse(String inputString) {
        Matcher m = (Matcher)EXTERNAL_MATCHER.get();
        m.reset(inputString);
        if (m.matches()) {
            return new BlobRef(m.group(1), Long.valueOf(m.group(2)), Long.valueOf(m.group(3)));
        }
        LOG.warn((Object)"Reparsing inline BLOB data is not supported; use SequenceFiles.");
        return new BlobRef();
    }
}

