/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.GenericJdbcManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CatalogQueryManager
extends GenericJdbcManager {
    public static final Log LOG = LogFactory.getLog((String)CatalogQueryManager.class.getName());

    public CatalogQueryManager(String driverClass, SqoopOptions opts) {
        super(driverClass, opts);
    }

    protected abstract String getListDatabasesQuery();

    @Override
    public String[] listDatabases() {
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        ArrayList<String> databases = new ArrayList<String>();
        try {
            c = this.getConnection();
            s = c.createStatement();
            rs = s.executeQuery(this.getListDatabasesQuery());
            while (rs.next()) {
                databases.add(rs.getString(1));
            }
            c.commit();
        }
        catch (SQLException sqle) {
            try {
                if (c != null) {
                    c.rollback();
                }
            }
            catch (SQLException ce) {
                LOG.error((Object)"Failed to rollback transaction", (Throwable)ce);
            }
            LOG.error((Object)"Failed to list databases", (Throwable)sqle);
            throw new RuntimeException(sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException re) {
                    LOG.error((Object)"Failed to close resultset", (Throwable)re);
                }
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException se) {
                    LOG.error((Object)"Failed to close statement", (Throwable)se);
                }
            }
        }
        return databases.toArray(new String[databases.size()]);
    }

    protected abstract String getListTablesQuery();

    @Override
    public String[] listTables() {
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        ArrayList<String> tables = new ArrayList<String>();
        try {
            c = this.getConnection();
            s = c.createStatement();
            rs = s.executeQuery(this.getListTablesQuery());
            while (rs.next()) {
                tables.add(rs.getString(1));
            }
            c.commit();
        }
        catch (SQLException sqle) {
            try {
                if (c != null) {
                    c.rollback();
                }
            }
            catch (SQLException ce) {
                LOG.error((Object)"Failed to rollback transaction", (Throwable)ce);
            }
            LOG.error((Object)"Failed to list tables", (Throwable)sqle);
            throw new RuntimeException(sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException re) {
                    LOG.error((Object)"Failed to close resultset", (Throwable)re);
                }
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException se) {
                    LOG.error((Object)"Failed to close statement", (Throwable)se);
                }
            }
        }
        return tables.toArray(new String[tables.size()]);
    }

    protected abstract String getListColumnsQuery(String var1);

    @Override
    public String[] getColumnNames(String tableName) {
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        ArrayList<String> columns = new ArrayList<String>();
        try {
            c = this.getConnection();
            s = c.createStatement();
            rs = s.executeQuery(this.getListColumnsQuery(tableName));
            while (rs.next()) {
                columns.add(rs.getString(1));
            }
            c.commit();
        }
        catch (SQLException sqle) {
            try {
                if (c != null) {
                    c.rollback();
                }
            }
            catch (SQLException ce) {
                LOG.error((Object)"Failed to rollback transaction", (Throwable)ce);
            }
            LOG.error((Object)"Failed to list columns", (Throwable)sqle);
            throw new RuntimeException(sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException re) {
                    LOG.error((Object)"Failed to close resultset", (Throwable)re);
                }
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException se) {
                    LOG.error((Object)"Failed to close statement", (Throwable)se);
                }
            }
        }
        return columns.toArray(new String[columns.size()]);
    }

    protected abstract String getPrimaryKeyQuery(String var1);

    @Override
    public String getPrimaryKey(String tableName) {
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        ArrayList<String> columns = new ArrayList<String>();
        try {
            c = this.getConnection();
            s = c.createStatement();
            rs = s.executeQuery(this.getPrimaryKeyQuery(tableName));
            while (rs.next()) {
                columns.add(rs.getString(1));
            }
            c.commit();
        }
        catch (SQLException sqle) {
            try {
                if (c != null) {
                    c.rollback();
                }
            }
            catch (SQLException ce) {
                LOG.error((Object)"Failed to rollback transaction", (Throwable)ce);
            }
            LOG.error((Object)"Failed to list primary key", (Throwable)sqle);
            throw new RuntimeException(sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException re) {
                    LOG.error((Object)"Failed to close resultset", (Throwable)re);
                }
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException se) {
                    LOG.error((Object)"Failed to close statement", (Throwable)se);
                }
            }
        }
        if (columns.size() == 0) {
            return null;
        }
        if (columns.size() > 1) {
            LOG.warn((Object)("The table " + tableName + " " + "contains a multi-column primary key. Sqoop will default to " + "the column " + (String)columns.get(0) + " only for this job."));
        }
        return (String)columns.get(0);
    }
}

