/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce;

import com.cloudera.sqoop.mapreduce.ExportJobBase;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileRecordReader;
import org.apache.hadoop.util.ReflectionUtils;

public class CombineShimRecordReader
extends RecordReader<LongWritable, Object> {
    public static final Log LOG = LogFactory.getLog((String)CombineShimRecordReader.class.getName());
    private CombineFileSplit split;
    private TaskAttemptContext context;
    private int index;
    private RecordReader<LongWritable, Object> rr;

    public CombineShimRecordReader(CombineFileSplit split, TaskAttemptContext context, Integer index) throws IOException, InterruptedException {
        this.index = index;
        this.split = split;
        this.context = context;
        this.createChildReader();
    }

    public void initialize(InputSplit curSplit, TaskAttemptContext curContext) throws IOException, InterruptedException {
        this.split = (CombineFileSplit)curSplit;
        this.context = curContext;
        if (null == this.rr) {
            this.createChildReader();
        }
        FileSplit fileSplit = new FileSplit(this.split.getPath(this.index), this.split.getOffset(this.index), this.split.getLength(this.index), this.split.getLocations());
        this.rr.initialize((InputSplit)fileSplit, this.context);
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.rr.getProgress();
    }

    public void close() throws IOException {
        if (null != this.rr) {
            this.rr.close();
            this.rr = null;
        }
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return (LongWritable)this.rr.getCurrentKey();
    }

    public Object getCurrentValue() throws IOException, InterruptedException {
        return this.rr.getCurrentValue();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.rr.nextKeyValue();
    }

    private void createChildReader() throws IOException, InterruptedException {
        LOG.debug((Object)("ChildSplit operates on: " + this.split.getPath(this.index)));
        Configuration conf = this.context.getConfiguration();
        Class rrClass = ExportJobBase.isSequenceFiles(conf, this.split.getPath(this.index)) ? SequenceFileRecordReader.class : LineRecordReader.class;
        this.rr = (RecordReader)ReflectionUtils.newInstance(rrClass, (Configuration)conf);
    }
}

