/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce;

import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.ExportOutputFormat;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class ExportBatchOutputFormat<K extends SqoopRecord, V>
extends ExportOutputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog(ExportBatchOutputFormat.class);

    @Override
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        try {
            return new ExportBatchRecordWriter(context);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public class ExportBatchRecordWriter
    extends ExportOutputFormat.ExportRecordWriter {
        public ExportBatchRecordWriter(TaskAttemptContext context) throws ClassNotFoundException, SQLException {
            super(ExportBatchOutputFormat.this, context);
        }

        @Override
        protected boolean isBatchExec() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected PreparedStatement getPreparedStatement(List<SqoopRecord> userRecords) throws SQLException {
            Connection conn;
            PreparedStatement stmt = null;
            Connection connection = conn = this.getConnection();
            synchronized (connection) {
                stmt = conn.prepareStatement(this.getInsertStatement(userRecords.size()));
            }
            for (SqoopRecord record : userRecords) {
                record.write(stmt, 0);
                stmt.addBatch();
            }
            return stmt;
        }

        @Override
        protected String getInsertStatement(int numRows) {
            int numSlots;
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO " + this.tableName + " ");
            if (this.columnNames != null) {
                numSlots = this.columnNames.length;
                sb.append("(");
                boolean first = true;
                for (String col : this.columnNames) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(col);
                    first = false;
                }
                sb.append(") ");
            } else {
                numSlots = this.columnCount;
            }
            sb.append("VALUES ");
            sb.append("(");
            for (int i = 0; i < numSlots; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append("?");
            }
            sb.append(")");
            return sb.toString();
        }
    }
}

