/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce;

import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.AsyncSqlOutputFormat;
import com.cloudera.sqoop.mapreduce.AsyncSqlRecordWriter;
import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class ExportOutputFormat<K extends SqoopRecord, V>
extends AsyncSqlOutputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog(ExportOutputFormat.class);

    @Override
    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        DBConfiguration dbConf = new DBConfiguration(conf);
        if (null == conf.get("mapreduce.jdbc.url")) {
            throw new IOException("Database connection URL is not set.");
        }
        if (null == dbConf.getOutputTableName()) {
            throw new IOException("Table name is not set for export");
        }
        if (null == dbConf.getOutputFieldNames() && 0 == dbConf.getOutputFieldCount()) {
            throw new IOException("Output field names are null and zero output field count set.");
        }
    }

    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        try {
            return new ExportRecordWriter(context);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public class ExportRecordWriter
    extends AsyncSqlRecordWriter<K, V> {
        protected String tableName;
        protected String[] columnNames;
        protected int columnCount;

        public ExportRecordWriter(TaskAttemptContext context) throws ClassNotFoundException, SQLException {
            super(context);
            Configuration conf = this.getConf();
            DBConfiguration dbConf = new DBConfiguration(conf);
            this.tableName = dbConf.getOutputTableName();
            this.columnNames = dbConf.getOutputFieldNames();
            this.columnCount = dbConf.getOutputFieldCount();
        }

        protected final String getTableName() {
            return this.tableName;
        }

        protected final String[] getColumnNames() {
            if (null == this.columnNames) {
                return null;
            }
            return Arrays.copyOf(this.columnNames, this.columnNames.length);
        }

        protected final int getColumnCount() {
            return this.columnCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected PreparedStatement getPreparedStatement(List<SqoopRecord> userRecords) throws SQLException {
            Connection conn;
            PreparedStatement stmt = null;
            Connection connection = conn = this.getConnection();
            synchronized (connection) {
                stmt = conn.prepareStatement(this.getInsertStatement(userRecords.size()));
            }
            int position = 0;
            for (SqoopRecord record : userRecords) {
                position += record.write(stmt, position);
            }
            return stmt;
        }

        protected String getInsertStatement(int numRows) {
            int i;
            int numSlots;
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO " + this.tableName + " ");
            if (this.columnNames != null) {
                numSlots = this.columnNames.length;
                sb.append("(");
                boolean first = true;
                for (String col : this.columnNames) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(col);
                    first = false;
                }
                sb.append(") ");
            } else {
                numSlots = this.columnCount;
            }
            sb.append("VALUES ");
            StringBuilder sbRow = new StringBuilder();
            sbRow.append("(");
            for (i = 0; i < numSlots; ++i) {
                if (i != 0) {
                    sbRow.append(", ");
                }
                sbRow.append("?");
            }
            sbRow.append(")");
            for (i = 0; i < numRows; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append((CharSequence)sbRow);
            }
            return sb.toString();
        }
    }
}

