/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce;

import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.mapreduce.ExportJobBase;
import com.cloudera.sqoop.mapreduce.SequenceFileExportMapper;
import com.cloudera.sqoop.mapreduce.TextExportMapper;
import com.cloudera.sqoop.mapreduce.UpdateOutputFormat;
import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import com.cloudera.sqoop.mapreduce.db.DBOutputFormat;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;

public class JdbcUpdateExportJob
extends ExportJobBase {
    public static final Log LOG = LogFactory.getLog((String)JdbcUpdateExportJob.class.getName());

    private static Class<? extends OutputFormat> getUpdateOutputFormat() throws IOException {
        return UpdateOutputFormat.class;
    }

    public JdbcUpdateExportJob(ExportJobContext context) throws IOException {
        super(context, null, null, JdbcUpdateExportJob.getUpdateOutputFormat());
    }

    public JdbcUpdateExportJob(ExportJobContext ctxt, Class<? extends Mapper> mapperClass, Class<? extends InputFormat> inputFormatClass, Class<? extends OutputFormat> outputFormatClass) {
        super(ctxt, mapperClass, inputFormatClass, outputFormatClass);
    }

    @Override
    protected Class<? extends Mapper> getMapperClass() {
        if (this.inputIsSequenceFiles()) {
            return SequenceFileExportMapper.class;
        }
        return TextExportMapper.class;
    }

    @Override
    protected void configureOutputFormat(Job job, String tableName, String tableClassName) throws IOException {
        ConnManager mgr = this.context.getConnManager();
        try {
            String username = this.options.getUsername();
            if (null == username || username.length() == 0) {
                DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString());
            } else {
                DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), username, this.options.getPassword());
            }
            String[] colNames = this.options.getColumns();
            if (null == colNames) {
                colNames = mgr.getColumnNames(tableName);
            }
            if (null == colNames) {
                throw new IOException("Export column names could not be determined for " + tableName);
            }
            String updateKeyColumns = this.options.getUpdateKeyCol();
            if (null == updateKeyColumns) {
                throw new IOException("Update key column not set in export job");
            }
            LinkedHashSet<String> updateKeys = new LinkedHashSet<String>();
            HashSet<String> updateKeysUppercase = new HashSet<String>();
            StringTokenizer stok = new StringTokenizer(updateKeyColumns, ",");
            while (stok.hasMoreTokens()) {
                String nextUpdateKey = stok.nextToken().trim();
                if (nextUpdateKey.length() > 0) {
                    updateKeys.add(nextUpdateKey);
                    updateKeysUppercase.add(nextUpdateKey.toUpperCase());
                    continue;
                }
                throw new RuntimeException("Invalid update key column value specified: '" + updateKeyColumns + "'");
            }
            if (updateKeys.size() == 0) {
                throw new IOException("Unpdate key columns not valid in export job");
            }
            String[] outColNames = new String[colNames.length - updateKeys.size()];
            int j = 0;
            for (int i = 0; i < colNames.length; ++i) {
                if (updateKeysUppercase.contains(colNames[i].toUpperCase())) continue;
                outColNames[j++] = colNames[i];
            }
            DBOutputFormat.setOutput(job, tableName, outColNames);
            job.setOutputFormatClass(this.getOutputFormatClass());
            job.getConfiguration().set("sqoop.mapreduce.export.table.class", tableClassName);
            job.getConfiguration().set("sqoop.mapreduce.export.update.col", updateKeyColumns);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Could not load OutputFormat", cnfe);
        }
    }
}

