/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce;

import com.cloudera.sqoop.lib.SqoopRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class MergeRecord
implements Configurable,
Writable {
    private SqoopRecord sqoopRecord;
    private boolean isNew;
    private Configuration config;

    public MergeRecord() {
        this.sqoopRecord = null;
        this.isNew = false;
        this.config = new Configuration();
    }

    public MergeRecord(SqoopRecord sr, boolean recordIsNew) {
        this.sqoopRecord = sr;
        this.isNew = recordIsNew;
        this.config = new Configuration();
    }

    public void setConf(Configuration conf) {
        this.config = conf;
    }

    public Configuration getConf() {
        return this.config;
    }

    public boolean isNewRecord() {
        return this.isNew;
    }

    public void setNewRecord(boolean newVal) {
        this.isNew = newVal;
    }

    public SqoopRecord getSqoopRecord() {
        return this.sqoopRecord;
    }

    public void setSqoopRecord(SqoopRecord record) {
        this.sqoopRecord = record;
    }

    public void readFields(DataInput in) throws IOException {
        this.isNew = in.readBoolean();
        String className = Text.readString((DataInput)in);
        if (null == this.sqoopRecord) {
            try {
                Class recordClass = this.config.getClassByName(className);
                this.sqoopRecord = (SqoopRecord)recordClass.newInstance();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        this.sqoopRecord.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.isNew);
        Text.writeString((DataOutput)out, (String)this.sqoopRecord.getClass().getName());
        this.sqoopRecord.write(out);
    }

    public String toString() {
        return "" + this.sqoopRecord;
    }
}

