/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce;

import com.cloudera.sqoop.mapreduce.db.DataDrivenDBInputFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class MySQLDumpInputFormat
extends DataDrivenDBInputFormat {
    public static final Log LOG = LogFactory.getLog((String)MySQLDumpInputFormat.class.getName());

    @Override
    public RecordReader<String, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return new MySQLDumpRecordReader(split);
    }

    public static class MySQLDumpRecordReader
    extends RecordReader<String, NullWritable> {
        private boolean delivered;
        private String clause;

        public MySQLDumpRecordReader(InputSplit split) {
            this.initialize(split, null);
        }

        public boolean nextKeyValue() {
            boolean hasNext = !this.delivered;
            this.delivered = true;
            return hasNext;
        }

        public String getCurrentKey() {
            return this.clause;
        }

        public NullWritable getCurrentValue() {
            return NullWritable.get();
        }

        public void close() {
        }

        public float getProgress() {
            return this.delivered ? 1.0f : 0.0f;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) {
            DataDrivenDBInputFormat.DataDrivenDBInputSplit dbSplit = (DataDrivenDBInputFormat.DataDrivenDBInputSplit)split;
            this.clause = "(" + dbSplit.getLowerClause() + ") AND (" + dbSplit.getUpperClause() + ")";
        }
    }
}

