/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce;

import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.UpdateOutputFormat;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class OracleUpsertOutputFormat<K extends SqoopRecord, V>
extends UpdateOutputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog(OracleUpsertOutputFormat.class);

    @Override
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        try {
            return new OracleUpsertRecordWriter(context);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public class OracleUpsertRecordWriter
    extends UpdateOutputFormat.UpdateRecordWriter {
        public OracleUpsertRecordWriter(TaskAttemptContext context) throws ClassNotFoundException, SQLException {
            super(OracleUpsertOutputFormat.this, context);
        }

        @Override
        protected String getUpdateStatement() {
            LinkedHashSet<String> updateKeyLookup = new LinkedHashSet<String>();
            for (String updateKey : this.updateCols) {
                updateKeyLookup.add(updateKey);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("MERGE INTO ");
            sb.append(this.tableName);
            sb.append(" USING dual ON ( ");
            boolean first = true;
            for (int i = 0; i < this.updateCols.length; ++i) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" AND ");
                }
                sb.append(this.updateCols[i]).append(" = ?");
            }
            sb.append(" )");
            sb.append("  WHEN MATCHED THEN UPDATE SET ");
            first = true;
            for (String col : this.columnNames) {
                if (updateKeyLookup.contains(col)) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(col);
                sb.append(" = ?");
            }
            sb.append("  WHEN NOT MATCHED THEN INSERT ( ");
            first = true;
            for (String col : this.columnNames) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(col);
            }
            sb.append(" ) VALUES ( ");
            first = true;
            for (String col : this.columnNames) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("?");
            }
            sb.append(" )");
            return sb.toString();
        }
    }
}

