/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce;

import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.ExportOutputFormat;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class SQLServerExportOutputFormat<K extends SqoopRecord, V>
extends ExportOutputFormat<K, V> {
    @Override
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        try {
            return new SQLServerExportRecordWriter(context);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public class SQLServerExportRecordWriter
    extends ExportOutputFormat.ExportRecordWriter {
        public SQLServerExportRecordWriter(TaskAttemptContext context) throws ClassNotFoundException, SQLException {
            super(context);
        }

        @Override
        protected String getInsertStatement(int numRows) {
            int i;
            int numSlots;
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO " + this.getTableName() + " ");
            String[] colNames = this.getColumnNames();
            if (colNames != null) {
                numSlots = colNames.length;
                sb.append("(");
                boolean first = true;
                for (String col : colNames) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(col);
                    first = false;
                }
                sb.append(") ");
            } else {
                numSlots = this.getColumnCount();
            }
            StringBuilder sbRow = new StringBuilder();
            sbRow.append("(SELECT ");
            for (i = 0; i < numSlots; ++i) {
                if (i != 0) {
                    sbRow.append(", ");
                }
                sbRow.append("?");
            }
            sbRow.append(") ");
            for (i = 0; i < numRows; ++i) {
                if (i != 0) {
                    sb.append("UNION ALL ");
                }
                sb.append((CharSequence)sbRow);
            }
            return sb.toString();
        }
    }
}

