/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce;

import com.cloudera.sqoop.lib.RecordParser;
import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.AutoProgressMapper;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.ReflectionUtils;

public class TextExportMapper
extends AutoProgressMapper<LongWritable, Text, SqoopRecord, NullWritable> {
    private SqoopRecord recordImpl;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        String recordClassName = conf.get("sqoop.mapreduce.export.table.class");
        if (null == recordClassName) {
            throw new IOException("Export table class name (sqoop.mapreduce.export.table.class) is not set!");
        }
        try {
            Class<?> cls = Class.forName(recordClassName, true, Thread.currentThread().getContextClassLoader());
            this.recordImpl = (SqoopRecord)ReflectionUtils.newInstance(cls, (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        if (null == this.recordImpl) {
            throw new IOException("Could not instantiate object of type " + recordClassName);
        }
    }

    public void map(LongWritable key, Text val, Mapper.Context context) throws IOException, InterruptedException {
        try {
            this.recordImpl.parse(val);
            context.write((Object)this.recordImpl, (Object)NullWritable.get());
        }
        catch (RecordParser.ParseError pe) {
            throw new IOException("Could not parse record: " + val, pe);
        }
    }
}

