/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.metastore;

import com.cloudera.sqoop.metastore.JobStorage;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class JobStorageFactory {
    private Configuration conf;
    public static final String AVAILABLE_STORAGES_KEY = "sqoop.job.storage.implementations";
    private static final String DEFAULT_AVAILABLE_STORAGES = "com.cloudera.sqoop.metastore.hsqldb.HsqldbJobStorage,com.cloudera.sqoop.metastore.hsqldb.AutoHsqldbStorage";

    public JobStorageFactory(Configuration config) {
        this.conf = config;
        if (this.conf.get(AVAILABLE_STORAGES_KEY) == null) {
            this.conf.set(AVAILABLE_STORAGES_KEY, DEFAULT_AVAILABLE_STORAGES);
        }
    }

    public JobStorage getJobStorage(Map<String, String> descriptor) {
        List storages = this.conf.getInstances(AVAILABLE_STORAGES_KEY, JobStorage.class);
        for (JobStorage stor : storages) {
            if (!stor.canAccept(descriptor)) continue;
            return stor;
        }
        return null;
    }
}

