/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.tool;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.cli.ToolOptions;
import com.cloudera.sqoop.tool.BaseSqoopTool;
import com.cloudera.sqoop.tool.SqoopTool;
import java.util.Set;

public class HelpTool
extends BaseSqoopTool {
    public HelpTool() {
        super("help");
    }

    private static String padRight(String str, int num) {
        StringBuilder sb = new StringBuilder();
        sb.append(str);
        for (int count = str.length(); count < num; ++count) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private void printAvailableTools() {
        System.out.println("usage: sqoop COMMAND [ARGS]");
        System.out.println("");
        System.out.println("Available commands:");
        Set<String> toolNames = HelpTool.getToolNames();
        int maxWidth = 0;
        for (String tool : toolNames) {
            maxWidth = Math.max(maxWidth, tool.length());
        }
        for (String tool : toolNames) {
            System.out.println("  " + HelpTool.padRight(tool, maxWidth + 2) + HelpTool.getToolDescription(tool));
        }
        System.out.println("");
        System.out.println("See 'sqoop help COMMAND' for information on a specific command.");
    }

    @Override
    public int run(SqoopOptions options) {
        if (this.extraArguments != null && this.extraArguments.length > 0) {
            if (this.hasUnrecognizedArgs(this.extraArguments, 1, this.extraArguments.length)) {
                return 1;
            }
            SqoopTool subTool = SqoopTool.getTool(this.extraArguments[0]);
            if (null == subTool) {
                System.out.println("No such tool: " + this.extraArguments[0]);
                System.out.println("Try 'sqoop help' for a list of available commands.");
                return 1;
            }
            ToolOptions toolOpts = new ToolOptions();
            subTool.configureOptions(toolOpts);
            subTool.printHelp(toolOpts);
            return 0;
        }
        this.printAvailableTools();
        return 0;
    }

    @Override
    public void printHelp(ToolOptions opts) {
        System.out.println("usage: sqoop " + this.getToolName() + " [COMMAND]");
    }
}

