/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.tool;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.cli.RelatedOptions;
import com.cloudera.sqoop.cli.ToolOptions;
import com.cloudera.sqoop.metastore.hsqldb.HsqldbMetaStore;
import com.cloudera.sqoop.tool.BaseSqoopTool;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetastoreTool
extends BaseSqoopTool {
    public static final Log LOG = LogFactory.getLog((String)MetastoreTool.class.getName());
    private HsqldbMetaStore metastore;
    private boolean shutdown = false;

    public MetastoreTool() {
        super("metastore");
    }

    @Override
    public int run(SqoopOptions options) {
        this.metastore = new HsqldbMetaStore(options.getConf());
        if (this.shutdown) {
            LOG.info((Object)"Shutting down metastore...");
            this.metastore.shutdown();
        } else {
            this.metastore.start();
            this.metastore.waitForServer();
            LOG.info((Object)"Server thread has quit.");
        }
        return 0;
    }

    @Override
    public void configureOptions(ToolOptions toolOptions) {
        RelatedOptions opts = new RelatedOptions("metastore arguments");
        OptionBuilder.withDescription((String)"Cleanly shut down a running metastore");
        OptionBuilder.withLongOpt((String)"shutdown");
        opts.addOption(OptionBuilder.create());
        toolOptions.addUniqueOptions(opts);
    }

    @Override
    public void applyOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        if (in.hasOption("shutdown")) {
            this.shutdown = true;
        }
    }

    @Override
    public void validateOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
    }
}

