/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.util;

import com.cloudera.sqoop.util.AsyncSink;
import com.cloudera.sqoop.util.NullAsyncSink;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Executor {
    public static final Log LOG = LogFactory.getLog((String)Executor.class.getName());

    private Executor() {
    }

    public static int exec(String[] args) throws IOException {
        NullAsyncSink s = new NullAsyncSink();
        return Executor.exec(args, s, s);
    }

    public static int exec(String[] args, AsyncSink outSink, AsyncSink errSink) throws IOException {
        return Executor.exec(args, null, outSink, errSink);
    }

    public static int exec(String[] args, String[] envp, AsyncSink outSink, AsyncSink errSink) throws IOException {
        Process p = Runtime.getRuntime().exec(args, envp);
        if (null != outSink) {
            outSink.processStream(p.getInputStream());
        }
        if (null != errSink) {
            errSink.processStream(p.getErrorStream());
        }
        while (true) {
            try {
                int ret = p.waitFor();
                return ret;
            }
            catch (InterruptedException ie) {
                continue;
            }
            break;
        }
    }

    public static List<String> getCurEnvpStrings() {
        Map<String, String> curEnv = System.getenv();
        ArrayList<String> array = new ArrayList<String>();
        if (null == curEnv) {
            return null;
        }
        for (Map.Entry<String, String> entry : curEnv.entrySet()) {
            array.add(entry.getKey() + "=" + entry.getValue());
        }
        return array;
    }
}

