/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.util;

import com.cloudera.sqoop.manager.ConnManager;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Jars {
    public static final Log LOG = LogFactory.getLog((String)Jars.class.getName());

    private Jars() {
    }

    public static String getSqoopJarPath() {
        return Jars.getJarPathForClass(Jars.class);
    }

    public static String getJarPathForClass(Class<? extends Object> classObj) {
        ClassLoader loader = classObj.getClassLoader();
        String classFile = classObj.getName().replaceAll("\\.", "/") + ".class";
        try {
            Enumeration<URL> itr = loader.getResources(classFile);
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = toReturn.replaceAll("\\+", "%2B");
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static String getDriverClassJar(ConnManager mgr) {
        if (null == mgr) {
            return null;
        }
        String driverClassName = mgr.getDriverClass();
        if (null == driverClassName) {
            return null;
        }
        try {
            Class<?> driverClass = Class.forName(driverClassName);
            return Jars.getJarPathForClass(driverClass);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.warn((Object)("No such class " + driverClassName + " available."));
            return null;
        }
    }
}

