/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.util;

import com.cloudera.sqoop.util.ExitSecurityException;
import java.security.Permission;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubprocessSecurityManager
extends SecurityManager {
    public static final Log LOG = LogFactory.getLog((String)SubprocessSecurityManager.class.getName());
    private SecurityManager parentSecurityManager;
    private boolean installed = false;
    private boolean allowReplacement = false;

    public void install() {
        LOG.debug((Object)"Installing subprocess security manager");
        this.parentSecurityManager = System.getSecurityManager();
        System.setSecurityManager(this);
        this.installed = true;
    }

    public void uninstall() {
        if (this.installed) {
            LOG.debug((Object)"Uninstalling subprocess security manager");
            this.allowReplacement = true;
            System.setSecurityManager(this.parentSecurityManager);
        }
    }

    @Override
    public void checkExit(int status) {
        LOG.debug((Object)("Rejecting System.exit call with status=" + status));
        throw new ExitSecurityException(status);
    }

    @Override
    public void checkPermission(Permission perm) {
        if (null != this.parentSecurityManager) {
            this.parentSecurityManager.checkPermission(perm);
        }
        if (!this.allowReplacement && perm.getName().equals("setSecurityManager")) {
            throw new SecurityException("Cannot replace security manager");
        }
    }
}

