/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.pentaho.plugin.jfreereport.reportcharts.BaseCollectorFunction;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;

public class CategorySetCollectorFunction
extends BaseCollectorFunction {
    private static final long serialVersionUID = -8138304452870844825L;
    private ArrayList valueColumns = new ArrayList();
    private ArrayList ignoreColumns = new ArrayList();
    private String categoryColumn;
    private int categoryStartColumn;
    private boolean generatedReport = false;

    public void setGeneratedReport(boolean value) {
        this.generatedReport = value;
    }

    public boolean isGeneratedReport() {
        return this.generatedReport;
    }

    public void setIgnoreColumn(int index, String field) {
        if (this.ignoreColumns.size() == index) {
            this.ignoreColumns.add(field);
        } else {
            this.ignoreColumns.set(index, field);
        }
    }

    public String getIgnoreColumn(int index) {
        return (String)this.ignoreColumns.get(index);
    }

    public int getIgnoreColumnCount() {
        return this.ignoreColumns.size();
    }

    public String[] getIgnoreColumn() {
        return this.ignoreColumns.toArray(new String[this.ignoreColumns.size()]);
    }

    public void setIgnoreColumn(String[] fields) {
        this.ignoreColumns.clear();
        this.ignoreColumns.addAll(Arrays.asList(fields));
    }

    public void setCategoryStartColumn(int value) {
        this.categoryStartColumn = value;
    }

    public int getCategoryStartColumn() {
        return this.categoryStartColumn;
    }

    public void setValueColumn(int index, String field) {
        if (this.valueColumns.size() == index) {
            this.valueColumns.add(field);
        } else {
            this.valueColumns.set(index, field);
        }
    }

    public String getValueColumn(int index) {
        return (String)this.valueColumns.get(index);
    }

    public int getValueColumnCount() {
        return this.valueColumns.size();
    }

    public String[] getValueColumn() {
        return this.valueColumns.toArray(new String[this.valueColumns.size()]);
    }

    public void setValueColumn(String[] fields) {
        this.valueColumns.clear();
        this.valueColumns.addAll(Arrays.asList(fields));
    }

    public String getCategoryColumn() {
        return this.categoryColumn;
    }

    public void setCategoryColumn(String categoryColumn) {
        this.categoryColumn = categoryColumn;
    }

    public Dataset createNewDataset() {
        return new DefaultCategoryDataset();
    }

    public void itemsAdvanced(ReportEvent reportEvent) {
        if (!FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)reportEvent)) {
            return;
        }
        if (this.isSummaryOnly()) {
            return;
        }
        this.buildDataset();
    }

    protected void buildDataset() {
        DefaultCategoryDataset categoryDataset = (DefaultCategoryDataset)this.getDatasourceValue();
        if (this.isGeneratedReport()) {
            this.buildAutoGeneratedDataSet(categoryDataset);
            return;
        }
        DataRow dataRow = this.getDataRow();
        Object categoryObject = dataRow.get(this.getCategoryColumn());
        Object categoryComparable = categoryObject instanceof Comparable ? (Comparable)categoryObject : "CATEGORYSETCOLL.USER_ERROR_CATEGORY_NOT_COMPARABLE";
        String[] seriesNames = this.getSeriesName();
        int maxIndex = Math.min(seriesNames.length, this.valueColumns.size());
        for (int i = 0; i < maxIndex; ++i) {
            Object tmp;
            String seriesName = seriesNames[i];
            String column = (String)this.valueColumns.get(i);
            Object valueObject = dataRow.get(column);
            if (this.isSeriesColumn() && (tmp = dataRow.get(seriesName)) != null) {
                seriesName = tmp.toString();
            }
            Number value = valueObject instanceof Number ? (Number)((Number)valueObject) : (Number)null;
            Number existingValue = this.queryExistingValueFromDataSet((CategoryDataset)categoryDataset, (Comparable)((Object)seriesName), (Comparable)categoryComparable);
            if (existingValue != null) {
                if (value == null) continue;
                double val = value.doubleValue();
                categoryDataset.addValue((Number)new Double(val + existingValue.doubleValue()), (Comparable)((Object)seriesName), (Comparable)categoryComparable);
                continue;
            }
            categoryDataset.addValue(value, (Comparable)((Object)seriesName), (Comparable)categoryComparable);
        }
    }

    protected Number queryExistingValueFromDataSet(CategoryDataset dataset, Comparable seriesName, Comparable columnKey) {
        try {
            return dataset.getValue(seriesName, columnKey);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public void groupFinished(ReportEvent reportEvent) {
        logger.debug((Object)"CATEGORYSETCOLL.USER_DEBUG_GROUPS_FINISHED");
        if (!FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)reportEvent)) {
            return;
        }
        if (!this.isSummaryOnly()) {
            return;
        }
        if (!FunctionUtilities.isDefinedGroup((String)this.getGroup(), (ReportEvent)reportEvent)) {
            return;
        }
        this.buildDataset();
    }

    private void buildAutoGeneratedDataSet(DefaultCategoryDataset categoryDataset) {
        DataRow dataRow = this.getDataRow();
        String[] columnNames = dataRow.getColumnNames();
        for (int i = this.categoryStartColumn; i < columnNames.length; ++i) {
            String seriesName = columnNames[i];
            if (!seriesName.startsWith("Summary_") || this.ignoreColumns.contains(seriesName)) continue;
            Object valueObject = dataRow.get(seriesName = seriesName.substring(8, seriesName.length() - 10));
            Number value = valueObject instanceof Number ? (Number)((Number)valueObject) : (Number)null;
            categoryDataset.addValue(value, (Comparable)((Object)seriesName), (Comparable)((Object)seriesName));
        }
    }

    public Expression getInstance() {
        CategorySetCollectorFunction fn = (CategorySetCollectorFunction)super.getInstance();
        fn.valueColumns = (ArrayList)this.valueColumns.clone();
        fn.ignoreColumns = (ArrayList)this.ignoreColumns.clone();
        return fn;
    }
}

