/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.imagemap.AbstractImageMapEntry;
import org.pentaho.reporting.engine.classic.core.imagemap.CircleImageMapEntry;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMap;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMapEntry;
import org.pentaho.reporting.engine.classic.core.imagemap.PolygonImageMapEntry;
import org.pentaho.reporting.engine.classic.core.imagemap.RectangleImageMapEntry;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.FloatList;
import org.pentaho.reporting.engine.classic.core.util.ReportDrawable;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class JFreeChartReportDrawable
implements ReportDrawable {
    private boolean debugRendering = ClassicEngineBoot.getInstance().getExtendedConfig().getBoolProperty("org.pentaho.plugin.jfreereport.reportcharts.DebugChartEntities");
    private boolean buggyDrawArea = ClassicEngineBoot.getInstance().getExtendedConfig().getBoolProperty("org.pentaho.plugin.jfreereport.reportcharts.DrawAreaBug");
    private JFreeChart chart;
    private ChartRenderingInfo chartRenderingInfo;
    private Rectangle2D bounds;

    public JFreeChartReportDrawable(JFreeChart chart, boolean collectRenderingInfo) {
        this.chart = chart;
        if (collectRenderingInfo) {
            this.chartRenderingInfo = new ChartRenderingInfo();
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D bounds) {
        this.bounds = (Rectangle2D)bounds.clone();
        if (this.chartRenderingInfo != null) {
            this.chartRenderingInfo.clear();
        }
        Graphics2D g2 = (Graphics2D)graphics2D.create();
        this.chart.draw(g2, bounds, this.chartRenderingInfo);
        g2.dispose();
        if (this.chartRenderingInfo == null || !this.debugRendering) {
            return;
        }
        graphics2D.setColor(Color.RED);
        Rectangle2D dataArea = this.getDataAreaOffset();
        EntityCollection entityCollection = this.chartRenderingInfo.getEntityCollection();
        for (int i = 0; i < entityCollection.getEntityCount(); ++i) {
            ChartEntity chartEntity = entityCollection.getEntity(i);
            if (chartEntity instanceof XYItemEntity || chartEntity instanceof CategoryItemEntity || chartEntity instanceof PieSectionEntity) {
                Area a = new Area(chartEntity.getArea());
                if (this.buggyDrawArea) {
                    a.transform(AffineTransform.getTranslateInstance(dataArea.getX(), dataArea.getY()));
                }
                a.intersect(new Area(dataArea));
                graphics2D.draw(a);
                continue;
            }
            graphics2D.draw(chartEntity.getArea());
        }
    }

    private Rectangle2D getDataAreaOffset() {
        return this.chartRenderingInfo.getPlotInfo().getDataArea();
    }

    public void setConfiguration(Configuration config) {
    }

    public void setStyleSheet(StyleSheet style) {
    }

    public void setResourceBundleFactory(ResourceBundleFactory bundleFactory) {
    }

    public ImageMap getImageMap(Rectangle2D bounds) {
        if (this.chartRenderingInfo == null) {
            return null;
        }
        Rectangle2D dataArea = this.getDataAreaOffset();
        Rectangle2D.Double otherArea = new Rectangle2D.Double();
        if (!ObjectUtilities.equal((Object)bounds, (Object)this.bounds)) {
            BufferedImage image = new BufferedImage(1, 1, 6);
            Graphics2D graphics = image.createGraphics();
            this.draw(graphics, bounds);
            graphics.dispose();
        }
        ImageMap map = new ImageMap();
        EntityCollection entityCollection = this.chartRenderingInfo.getEntityCollection();
        int count = entityCollection.getEntityCount();
        for (int i = 0; i < count; ++i) {
            AbstractImageMapEntry entry;
            ChartEntity chartEntity = entityCollection.getEntity(i);
            Shape area = chartEntity.getArea();
            String hrefValue = chartEntity.getURLText();
            String tooltipValue = chartEntity.getToolTipText();
            if (StringUtils.isEmpty((String)tooltipValue) && StringUtils.isEmpty((String)hrefValue) || (entry = chartEntity instanceof XYItemEntity || chartEntity instanceof CategoryItemEntity || chartEntity instanceof PieSectionEntity ? this.createMapEntry(area, dataArea) : this.createMapEntry(area, otherArea)) == null) continue;
            if (!StringUtils.isEmpty((String)hrefValue)) {
                entry.setAttribute("http://www.w3.org/1999/xhtml", "href", hrefValue);
            }
            if (!StringUtils.isEmpty((String)tooltipValue)) {
                entry.setAttribute("http://www.w3.org/1999/xhtml", "title", tooltipValue);
            }
            map.addMapEntry((ImageMapEntry)entry);
        }
        return map;
    }

    private AbstractImageMapEntry createMapEntry(Shape area, Rectangle2D dataArea) {
        Ellipse2D ellipse2D;
        if (this.buggyDrawArea) {
            if (area instanceof Ellipse2D) {
                ellipse2D = (Ellipse2D)area;
                if (ellipse2D.getWidth() == ellipse2D.getHeight()) {
                    return new CircleImageMapEntry((float)(ellipse2D.getCenterX() + dataArea.getX()), (float)(ellipse2D.getCenterY() + dataArea.getY()), (float)(ellipse2D.getWidth() / 2.0));
                }
            } else if (area instanceof Rectangle2D) {
                Rectangle2D rect = (Rectangle2D)area;
                return new RectangleImageMapEntry((float)(rect.getX() + dataArea.getX()), (float)(rect.getY() + dataArea.getY()), (float)(rect.getX() + rect.getWidth()), (float)(rect.getY() + rect.getHeight()));
            }
        } else if (area instanceof Ellipse2D) {
            ellipse2D = (Ellipse2D)area;
            if (ellipse2D.getWidth() == ellipse2D.getHeight()) {
                return new CircleImageMapEntry((float)ellipse2D.getCenterX(), (float)ellipse2D.getCenterY(), (float)(ellipse2D.getWidth() / 2.0));
            }
        } else if (area instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)area;
            return new RectangleImageMapEntry((float)rect.getX(), (float)rect.getY(), (float)(rect.getX() + rect.getWidth()), (float)(rect.getY() + rect.getHeight()));
        }
        Area a = new Area(area);
        if (this.buggyDrawArea) {
            a.transform(AffineTransform.getTranslateInstance(dataArea.getX(), dataArea.getY()));
        }
        if (!dataArea.isEmpty()) {
            a.intersect(new Area(dataArea));
        }
        PathIterator pathIterator = a.getPathIterator(null, 2.0);
        FloatList floats = new FloatList(100);
        float[] coords = new float[6];
        while (!pathIterator.isDone()) {
            int retval = pathIterator.currentSegment(coords);
            if (retval == 0 || retval == 1) {
                floats.add(coords[0]);
                floats.add(coords[1]);
            }
            pathIterator.next();
        }
        if (floats.size() == 0) {
            return null;
        }
        return new PolygonImageMapEntry(floats.toArray());
    }
}

