/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.TableOrder;
import org.pentaho.plugin.jfreereport.reportcharts.AbstractChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.FormulaPieTooltipGenerator;
import org.pentaho.plugin.jfreereport.reportcharts.FormulaPieURLGenerator;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class MultiPieChartExpression
extends AbstractChartExpression {
    private static final long serialVersionUID = -7796999107015376070L;
    private boolean multipieByRow = true;
    private String multipieLabelFormat = "{2}";
    private Color shadowPaint;
    private Double shadowXOffset;
    private Double shadowYOffset;
    private Font pieTitleFont;
    private String pieNoDataMessage;

    public String getPieNoDataMessage() {
        return this.pieNoDataMessage;
    }

    public void setPieNoDataMessage(String pieNoDataMessage) {
        this.pieNoDataMessage = pieNoDataMessage;
    }

    public Font getPieTitleFont() {
        return this.pieTitleFont;
    }

    public void setPieTitleFont(Font pieTitleFont) {
        this.pieTitleFont = pieTitleFont;
    }

    public String getMultipieLabelFormat() {
        return this.multipieLabelFormat;
    }

    public void setMultipieLabelFormat(String value) {
        this.multipieLabelFormat = value;
    }

    public boolean isMultipieByRow() {
        return this.multipieByRow;
    }

    public void setMultipieByRow(boolean value) {
        this.multipieByRow = value;
    }

    public Color getShadowPaint() {
        return this.shadowPaint;
    }

    public void setShadowPaint(Color shadowPaint) {
        this.shadowPaint = shadowPaint;
    }

    public Double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(Double shadowXOffset) {
        this.shadowXOffset = shadowXOffset;
    }

    public Double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(Double shadowYOffset) {
        this.shadowYOffset = shadowYOffset;
    }

    protected JFreeChart computeChart(Dataset dataset) {
        CategoryDataset categoryDataset = !(dataset instanceof CategoryDataset) ? null : (CategoryDataset)dataset;
        TableOrder order = this.isMultipieByRow() ? TableOrder.BY_ROW : TableOrder.BY_COLUMN;
        if (this.isThreeD()) {
            return ChartFactory.createMultiplePieChart3D((String)this.computeTitle(), (CategoryDataset)categoryDataset, (TableOrder)order, (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
        }
        return ChartFactory.createMultiplePieChart((String)this.computeTitle(), (CategoryDataset)categoryDataset, (TableOrder)order, (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
    }

    protected void configureSubChart(JFreeChart chart) {
        LegendTitle chLegend;
        TextTitle chartTitle = chart.getTitle();
        if (chartTitle != null) {
            if (this.getPieTitleFont() != null) {
                chartTitle.setFont(this.getPieTitleFont());
            } else {
                Font titleFont = Font.decode(this.getTitleFont());
                chartTitle.setFont(titleFont);
            }
        }
        if (!this.isAntiAlias()) {
            chart.setAntiAlias(false);
        }
        if ((chLegend = chart.getLegend()) != null) {
            RectangleEdge loc = this.translateEdge(this.getLegendLocation().toLowerCase());
            if (loc != null) {
                chLegend.setPosition(loc);
            }
            if (this.getLegendFont() != null) {
                chLegend.setItemFont(Font.decode(this.getLegendFont()));
            }
            if (!this.isDrawLegendBorder()) {
                chLegend.setBorder(BlockBorder.NONE);
            }
            if (this.getLegendBackgroundColor() != null) {
                chLegend.setBackgroundPaint((Paint)this.getLegendBackgroundColor());
            }
            if (this.getLegendTextColor() != null) {
                chLegend.setItemPaint((Paint)this.getLegendTextColor());
            }
        }
        Plot plot = chart.getPlot();
        plot.setNoDataMessageFont(Font.decode(this.getLabelFont()));
        String pieNoData = this.getPieNoDataMessage();
        if (pieNoData != null) {
            plot.setNoDataMessage(pieNoData);
        } else {
            String message = this.getNoDataMessage();
            if (message != null) {
                plot.setNoDataMessage(message);
            }
        }
    }

    protected void configureChart(JFreeChart chart) {
        CategoryDataset c;
        super.configureChart(chart);
        Plot plot = chart.getPlot();
        MultiplePiePlot mpp = (MultiplePiePlot)plot;
        JFreeChart pc = mpp.getPieChart();
        this.configureSubChart(pc);
        PiePlot pp = (PiePlot)pc.getPlot();
        if (!StringUtils.isEmpty((String)this.getTooltipFormula())) {
            pp.setToolTipGenerator((PieToolTipGenerator)new FormulaPieTooltipGenerator(this.getRuntime(), this.getTooltipFormula()));
        }
        if (!StringUtils.isEmpty((String)this.getUrlFormula())) {
            pp.setURLGenerator((PieURLGenerator)new FormulaPieURLGenerator(this.getRuntime(), this.getUrlFormula()));
        }
        if (this.shadowPaint != null) {
            pp.setShadowPaint((Paint)this.shadowPaint);
        }
        if (this.shadowXOffset != null) {
            pp.setShadowXOffset(this.shadowXOffset.doubleValue());
        }
        if (this.shadowYOffset != null) {
            pp.setShadowYOffset(this.shadowYOffset.doubleValue());
        }
        if ((c = mpp.getDataset()) != null) {
            String[] colors = this.getSeriesColor();
            int keysSize = c.getColumnKeys().size();
            for (int i = 0; i < colors.length; ++i) {
                if (keysSize <= i) continue;
                pp.setSectionPaint(c.getColumnKey(i), (Paint)this.parseColorFromString(colors[i]));
            }
        }
        if (!StringUtils.isEmpty((String)this.getLabelFont())) {
            pp.setLabelFont(Font.decode(this.getLabelFont()));
        }
        if (Boolean.FALSE.equals(this.getItemsLabelVisible())) {
            pp.setLabelGenerator(null);
        } else {
            StandardPieSectionLabelGenerator labelGen = new StandardPieSectionLabelGenerator(this.multipieLabelFormat);
            pp.setLabelGenerator((PieSectionLabelGenerator)labelGen);
        }
    }
}

