/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.pentaho.plugin.jfreereport.reportcharts.XYLineChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.backport.ExtTimeTableXYDataset;

public class XYAreaChartExpression
extends XYLineChartExpression {
    private static final long serialVersionUID = -8475649582680588912L;

    public static JFreeChart createTimeSeriesChart(String title, String timeAxisLabel, String valueAxisLabel, XYDataset dataset, boolean legend, boolean tooltips, boolean urls, boolean stacked) {
        DateAxis timeAxis = new DateAxis(timeAxisLabel);
        timeAxis.setLowerMargin(0.02);
        timeAxis.setUpperMargin(0.02);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        valueAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(dataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, null);
        StandardXYToolTipGenerator toolTipGenerator = null;
        if (tooltips) {
            toolTipGenerator = StandardXYToolTipGenerator.getTimeSeriesInstance();
        }
        StandardXYURLGenerator urlGenerator = null;
        if (urls) {
            urlGenerator = new StandardXYURLGenerator();
        }
        Object renderer = stacked ? new StackedXYAreaRenderer2() : new XYAreaRenderer2();
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)toolTipGenerator);
        renderer.setURLGenerator((XYURLGenerator)urlGenerator);
        plot.setRenderer((XYItemRenderer)renderer);
        return new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
    }

    protected JFreeChart computeXYChart(XYDataset xyDataset) {
        JFreeChart chart;
        if (xyDataset instanceof TimeSeriesCollection) {
            if (this.isStacked()) {
                ExtTimeTableXYDataset tableXYDataset = this.convertToTable(xyDataset);
                chart = XYAreaChartExpression.createTimeSeriesChart(this.computeTitle(), this.getDomainTitle(), this.getRangeTitle(), (XYDataset)tableXYDataset, this.isShowLegend(), false, false, this.isStacked());
            } else {
                chart = XYAreaChartExpression.createTimeSeriesChart(this.computeTitle(), this.getDomainTitle(), this.getRangeTitle(), xyDataset, this.isShowLegend(), false, false, this.isStacked());
            }
        } else {
            PlotOrientation orientation = this.computePlotOrientation();
            chart = this.isStacked() ? XYAreaChartExpression.createStackedXYAreaChart(this.computeTitle(), this.getDomainTitle(), this.getRangeTitle(), xyDataset, orientation, this.isShowLegend(), false, false) : ChartFactory.createXYAreaChart((String)this.computeTitle(), (String)this.getDomainTitle(), (String)this.getRangeTitle(), (XYDataset)xyDataset, (PlotOrientation)orientation, (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
        }
        this.configureLogarithmicAxis(chart.getXYPlot());
        return chart;
    }

    protected static JFreeChart createStackedXYAreaChart(String title, String xAxisLabel, String yAxisLabel, XYDataset dataset, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        NumberAxis xAxis = new NumberAxis(xAxisLabel);
        xAxis.setAutoRangeIncludesZero(false);
        xAxis.setLowerMargin(0.0);
        xAxis.setUpperMargin(0.0);
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        StandardXYToolTipGenerator toolTipGenerator = null;
        if (tooltips) {
            toolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator urlGenerator = null;
        if (urls) {
            urlGenerator = new StandardXYURLGenerator();
        }
        StackedXYAreaRenderer2 renderer = new StackedXYAreaRenderer2((XYToolTipGenerator)toolTipGenerator, (XYURLGenerator)urlGenerator);
        renderer.setOutline(true);
        XYPlot plot = new XYPlot(dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setOrientation(orientation);
        plot.setRangeAxis((ValueAxis)yAxis);
        return new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
    }
}

