/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;
import org.pentaho.plugin.jfreereport.reportcharts.XYChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.backport.ExtTimeTableXYDataset;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;

public class XYBarChartExpression
extends XYChartExpression {
    private static final long serialVersionUID = -1190325024526412335L;
    private Double margin;
    private boolean renderPercentages;

    public Double getMargin() {
        return this.margin;
    }

    public void setMargin(Double margin) {
        this.margin = margin;
    }

    public boolean isRenderPercentages() {
        return this.renderPercentages;
    }

    public void setRenderPercentages(boolean renderPercentages) {
        this.renderPercentages = renderPercentages;
    }

    protected static JFreeChart createTimeSeriesChart(String title, String timeAxisLabel, String valueAxisLabel, XYDataset dataset, boolean legend, boolean tooltips, boolean urls, boolean stacked) {
        DateAxis timeAxis = new DateAxis(timeAxisLabel);
        timeAxis.setLowerMargin(0.02);
        timeAxis.setUpperMargin(0.02);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        valueAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(dataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, null);
        StandardXYToolTipGenerator toolTipGenerator = null;
        if (tooltips) {
            toolTipGenerator = StandardXYToolTipGenerator.getTimeSeriesInstance();
        }
        StandardXYURLGenerator urlGenerator = null;
        if (urls) {
            urlGenerator = new StandardXYURLGenerator();
        }
        Object renderer = stacked ? new StackedXYBarRenderer() : new XYBarRenderer();
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)toolTipGenerator);
        renderer.setURLGenerator((XYURLGenerator)urlGenerator);
        plot.setRenderer((XYItemRenderer)renderer);
        return new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
    }

    protected JFreeChart computeXYChart(XYDataset xyDataset) {
        JFreeChart chart;
        if (xyDataset instanceof TimeSeriesCollection) {
            if (this.isStacked()) {
                ExtTimeTableXYDataset tableXYDataset = this.convertToTable(xyDataset);
                chart = XYBarChartExpression.createTimeSeriesChart(this.computeTitle(), this.getDomainTitle(), this.getRangeTitle(), (XYDataset)tableXYDataset, this.isShowLegend(), false, false, true);
            } else {
                chart = XYBarChartExpression.createTimeSeriesChart(this.computeTitle(), this.getDomainTitle(), this.getRangeTitle(), xyDataset, this.isShowLegend(), false, false, false);
            }
        } else {
            PlotOrientation orientation = this.computePlotOrientation();
            if (this.isStacked() && xyDataset instanceof XYSeriesCollection) {
                XYSeriesCollection xySeriesCollection = (XYSeriesCollection)xyDataset;
                chart = XYBarChartExpression.createStackedXYBarChart(this.computeTitle(), this.getDomainTitle(), false, this.getRangeTitle(), this.convertToTable(xySeriesCollection), orientation, this.isShowLegend(), false, false);
            } else if (this.isStacked() && xyDataset instanceof TableXYDataset) {
                TableXYDataset dataset = (TableXYDataset)xyDataset;
                chart = XYBarChartExpression.createStackedXYBarChart(this.computeTitle(), this.getDomainTitle(), false, this.getRangeTitle(), dataset, orientation, this.isShowLegend(), false, false);
            } else {
                chart = XYBarChartExpression.createXYBarChart(this.computeTitle(), this.getDomainTitle(), false, this.getRangeTitle(), xyDataset, orientation, this.isShowLegend(), false, false);
            }
        }
        this.configureLogarithmicAxis(chart.getXYPlot());
        return chart;
    }

    public static JFreeChart createXYBarChart(String title, String xAxisLabel, boolean dateAxis, String yAxisLabel, XYDataset dataset, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        DateAxis domainAxis = null;
        if (dateAxis) {
            domainAxis = new DateAxis(xAxisLabel);
        } else {
            NumberAxis axis = new NumberAxis(xAxisLabel);
            axis.setAutoRangeIncludesZero(false);
            domainAxis = axis;
        }
        NumberAxis valueAxis = new NumberAxis(yAxisLabel);
        XYBarRenderer renderer = new XYBarRenderer();
        renderer.setUseYInterval(true);
        if (tooltips) {
            StandardXYToolTipGenerator tt = dateAxis ? StandardXYToolTipGenerator.getTimeSeriesInstance() : new StandardXYToolTipGenerator();
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)tt);
        }
        if (urls) {
            renderer.setURLGenerator((XYURLGenerator)new StandardXYURLGenerator());
        }
        XYPlot plot = new XYPlot(dataset, (ValueAxis)domainAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer);
        plot.setOrientation(orientation);
        return new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
    }

    private static JFreeChart createStackedXYBarChart(String title, String xAxisLabel, boolean dateAxis, String yAxisLabel, TableXYDataset dataset, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        DateAxis domainAxis = null;
        if (dateAxis) {
            domainAxis = new DateAxis(xAxisLabel);
        } else {
            NumberAxis axis = new NumberAxis(xAxisLabel);
            axis.setAutoRangeIncludesZero(false);
            domainAxis = axis;
        }
        NumberAxis valueAxis = new NumberAxis(yAxisLabel);
        StackedXYBarRenderer renderer = new StackedXYBarRenderer();
        renderer.setUseYInterval(true);
        if (tooltips) {
            StandardXYToolTipGenerator tt = dateAxis ? StandardXYToolTipGenerator.getTimeSeriesInstance() : new StandardXYToolTipGenerator();
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)tt);
        }
        if (urls) {
            renderer.setURLGenerator((XYURLGenerator)new StandardXYURLGenerator());
        }
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)domainAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer);
        plot.setOrientation(orientation);
        return new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
    }

    protected void configureChart(JFreeChart chart) {
        super.configureChart(chart);
        XYPlot xypl = chart.getXYPlot();
        XYItemRenderer renderer = xypl.getRenderer();
        XYBarRenderer br = (XYBarRenderer)renderer;
        br.setDrawBarOutline(this.isChartSectionOutline());
        if (this.margin != null) {
            br.setMargin(this.margin.doubleValue());
        }
        if (this.isStacked() && this.renderPercentages && br instanceof StackedXYBarRenderer) {
            StackedXYBarRenderer sbr = (StackedXYBarRenderer)br;
            sbr.setRenderAsPercentages(true);
            ValueAxis rangeAxis = xypl.getRangeAxis();
            int level = this.getRuntime().getProcessingContext().getCompatibilityLevel();
            if (ClassicEngineBoot.isEnforceCompatibilityFor((int)level, (int)3, (int)8, (int)99)) {
                if (this.getRangeMinimum() != 0.0) {
                    rangeAxis.setLowerBound(this.getRangeMinimum());
                }
                if (this.getRangeMaximum() != 1.0) {
                    rangeAxis.setUpperBound(this.getRangeMaximum());
                }
                if (this.getRangeMinimum() == 0.0 && this.getRangeMaximum() == 0.0) {
                    rangeAxis.setLowerBound(0.0);
                    rangeAxis.setUpperBound(1.0);
                    rangeAxis.setAutoRange(true);
                }
            } else {
                rangeAxis.setLowerBound(this.getRangeMinimum());
                rangeAxis.setUpperBound(this.getRangeMaximum());
                rangeAxis.setAutoRange(this.isRangeAxisAutoRange());
            }
        }
    }

    public boolean isDrawBarOutline() {
        return this.isChartSectionOutline();
    }

    public void setDrawBarOutline(boolean value) {
        this.setChartSectionOutline(value);
    }
}

