/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.time.Year;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;
import org.pentaho.plugin.jfreereport.reportcharts.AbstractChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.FormulaXYZTooltipGenerator;
import org.pentaho.plugin.jfreereport.reportcharts.FormulaXYZURLGenerator;
import org.pentaho.plugin.jfreereport.reportcharts.LogXYItemLabelGenerator;
import org.pentaho.plugin.jfreereport.reportcharts.ScalingLogarithmicAxis;
import org.pentaho.plugin.jfreereport.reportcharts.backport.ExtCategoryTableXYDataset;
import org.pentaho.plugin.jfreereport.reportcharts.backport.ExtTimeTableXYDataset;
import org.pentaho.plugin.jfreereport.reportcharts.backport.FastNumberTickUnit;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.LegacyUpdateHandler;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formatting.FastDecimalFormat;

public abstract class XYChartExpression
extends AbstractChartExpression
implements LegacyUpdateHandler {
    private String titlePositionText = "top";
    private Paint borderPaint = Color.BLACK;
    private boolean horizontal = false;
    private boolean stacked = false;
    private boolean domainVerticalTickLabels = false;
    private boolean domainIncludesZero = false;
    private boolean domainStickyZero = false;
    private NumberFormat domainTickFormat = null;
    private String domainTickFormatString;
    private String domainTitle = null;
    private Font domainTitleFont = TextTitle.DEFAULT_FONT;
    private Font domainTickFont = null;
    private double domainMinimum = 0.0;
    private double domainMaximum = 1.0;
    private boolean domainAxisAutoRange = true;
    private Class domainTimePeriod;
    private double domainPeriodCount = 0.0;
    private String rangeTitle = null;
    private Font rangeTitleFont = TextTitle.DEFAULT_FONT;
    private Font rangeTickFont;
    private double rangeMinimum = 0.0;
    private double rangeMaximum = 1.0;
    private boolean rangeIncludesZero = true;
    private boolean rangeStickyZero = true;
    private boolean rangeAxisAutoRange = true;
    private NumberFormat rangeTickFormat;
    private String rangeTickFormatString;
    private boolean humanReadableLogarithmicFormat;
    private boolean logarithmicAxis;
    private Class rangeTimePeriod;
    private double rangePeriodCount;

    protected XYChartExpression() {
    }

    public boolean isDomainAxisAutoRange() {
        return this.domainAxisAutoRange;
    }

    public void setDomainAxisAutoRange(boolean domainAxisAutoRange) {
        this.domainAxisAutoRange = domainAxisAutoRange;
    }

    public boolean isRangeAxisAutoRange() {
        return this.rangeAxisAutoRange;
    }

    public void setRangeAxisAutoRange(boolean rangeAxisAutoRange) {
        this.rangeAxisAutoRange = rangeAxisAutoRange;
    }

    public Class getDomainTimePeriod() {
        return this.domainTimePeriod;
    }

    public void setDomainTimePeriod(Class domainTimePeriod) {
        this.domainTimePeriod = domainTimePeriod;
    }

    public Class getRangeTimePeriod() {
        return this.rangeTimePeriod;
    }

    public void setRangeTimePeriod(Class rangeTimePeriod) {
        this.rangeTimePeriod = rangeTimePeriod;
    }

    public boolean isHumanReadableLogarithmicFormat() {
        return this.humanReadableLogarithmicFormat;
    }

    public void setHumanReadableLogarithmicFormat(boolean humanReadableLogarithmicFormat) {
        this.humanReadableLogarithmicFormat = humanReadableLogarithmicFormat;
    }

    public boolean isLogarithmicAxis() {
        return this.logarithmicAxis;
    }

    public void setLogarithmicAxis(boolean logarithmicAxis) {
        this.logarithmicAxis = logarithmicAxis;
    }

    public Expression getInstance() {
        XYChartExpression chartExpression = (XYChartExpression)super.getInstance();
        if (chartExpression.domainTickFormat != null) {
            chartExpression.domainTickFormat = (NumberFormat)chartExpression.domainTickFormat.clone();
        }
        if (chartExpression.rangeTickFormat != null) {
            chartExpression.rangeTickFormat = (NumberFormat)chartExpression.rangeTickFormat.clone();
        }
        return chartExpression;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public boolean isDomainVerticalTickLabels() {
        return this.domainVerticalTickLabels;
    }

    public void setDomainVerticalTickLabels(boolean domainVerticalTickLabels) {
        this.domainVerticalTickLabels = domainVerticalTickLabels;
    }

    public boolean isDomainIncludesZero() {
        return this.domainIncludesZero;
    }

    public void setDomainIncludesZero(boolean domainIncludesZero) {
        this.domainIncludesZero = domainIncludesZero;
    }

    public boolean isDomainStickyZero() {
        return this.domainStickyZero;
    }

    public void setDomainStickyZero(boolean domainStickyZero) {
        this.domainStickyZero = domainStickyZero;
    }

    public boolean isRangeIncludesZero() {
        return this.rangeIncludesZero;
    }

    public void setRangeIncludesZero(boolean rangeIncludesZero) {
        this.rangeIncludesZero = rangeIncludesZero;
    }

    public boolean isRangeStickyZero() {
        return this.rangeStickyZero;
    }

    public void setRangeStickyZero(boolean rangeStickyZero) {
        this.rangeStickyZero = rangeStickyZero;
    }

    public void setPlotBackgroundColor(Color plotBackgroundPaint) {
        if (plotBackgroundPaint != null) {
            super.setPlotBackgroundColor(plotBackgroundPaint);
        }
    }

    public Color getPlotBackgroundColor() {
        return super.getPlotBackgroundColor();
    }

    public void setPlotBackgroundPaint(Paint plotBackgroundPaint) {
        this.setPlotBackgroundColor((Color)plotBackgroundPaint);
    }

    public Paint getPlotBackgroundPaint() {
        return this.getPlotBackgroundColor();
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean value) {
        this.horizontal = value;
    }

    public boolean isBorderVisible() {
        return this.isShowBorder();
    }

    public void setBorderVisible(boolean borderVisible) {
        this.setShowBorder(borderVisible);
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setBorderPaint(Paint borderPaint) {
        this.borderPaint = borderPaint;
    }

    public String getTitlePositionText() {
        return this.titlePositionText;
    }

    public void setTitlePositionText(String titlePositionText) {
        this.titlePositionText = titlePositionText;
    }

    public RectangleEdge getTitlePosition() {
        return this.translateEdge(this.titlePositionText);
    }

    public void setTitlePosition(RectangleEdge titlePosition) {
        this.titlePositionText = RectangleEdge.TOP.equals((Object)titlePosition) ? "top" : (RectangleEdge.LEFT.equals((Object)titlePosition) ? "left" : (RectangleEdge.BOTTOM.equals((Object)titlePosition) ? "bottom" : (RectangleEdge.RIGHT.equals((Object)titlePosition) ? "right" : "left")));
    }

    public String getDomainTitle() {
        return this.domainTitle;
    }

    public void setDomainTitle(String domainTitle) {
        this.domainTitle = domainTitle;
    }

    public String getRangeTitle() {
        return this.rangeTitle;
    }

    public void setRangeTitle(String rangeTitle) {
        this.rangeTitle = rangeTitle;
    }

    public Font getDomainTitleFont() {
        return this.domainTitleFont;
    }

    public void setDomainTitleFont(Font domainTitleFont) {
        this.domainTitleFont = domainTitleFont;
    }

    public Font getDomainTickFont() {
        return this.domainTickFont;
    }

    public void setDomainTickFont(Font domainTickFont) {
        this.domainTickFont = domainTickFont;
    }

    public NumberFormat getDomainTickFormat() {
        return this.domainTickFormat;
    }

    public void setDomainTickFormat(NumberFormat domainTickFormat) {
        this.domainTickFormat = domainTickFormat;
    }

    public Font getRangeTitleFont() {
        return this.rangeTitleFont;
    }

    public void setRangeTitleFont(Font rangeTitleFont) {
        this.rangeTitleFont = rangeTitleFont;
    }

    public NumberFormat getRangeTickFormat() {
        return this.rangeTickFormat;
    }

    public void setRangeTickFormat(NumberFormat rangeTickFormat) {
        this.rangeTickFormat = rangeTickFormat;
    }

    public String getDomainTickFormatString() {
        return this.domainTickFormatString;
    }

    public void setDomainTickFormatString(String domainTickFormatString) {
        this.domainTickFormatString = domainTickFormatString;
    }

    public String getRangeTickFormatString() {
        return this.rangeTickFormatString;
    }

    public void setRangeTickFormatString(String rangeTickFormatString) {
        this.rangeTickFormatString = rangeTickFormatString;
    }

    public Font getRangeTickFont() {
        return this.rangeTickFont;
    }

    public void setRangeTickFont(Font rangeTickFont) {
        this.rangeTickFont = rangeTickFont;
    }

    public double getRangeMinimum() {
        return this.rangeMinimum;
    }

    public void setRangeMinimum(double rangeMinimum) {
        this.rangeMinimum = rangeMinimum;
    }

    public double getRangeMaximum() {
        return this.rangeMaximum;
    }

    public void setRangeMaximum(double rangeMaximum) {
        this.rangeMaximum = rangeMaximum;
    }

    public double getDomainMinimum() {
        return this.domainMinimum;
    }

    public void setDomainMinimum(double domainMinimum) {
        this.domainMinimum = domainMinimum;
    }

    public double getDomainMaximum() {
        return this.domainMaximum;
    }

    public void setDomainMaximum(double domainMaximum) {
        this.domainMaximum = domainMaximum;
    }

    protected JFreeChart computeChart(Dataset dataset) {
        if (!(dataset instanceof XYDataset)) {
            return this.computeXYChart(null);
        }
        XYDataset xyDataset = (XYDataset)dataset;
        return this.computeXYChart(xyDataset);
    }

    protected void configureLogarithmicAxis(XYPlot plot) {
        if (this.isLogarithmicAxis()) {
            LogarithmicAxis logarithmicAxis;
            if (this.isHumanReadableLogarithmicFormat()) {
                plot.getRenderer().setBaseItemLabelGenerator((XYItemLabelGenerator)new LogXYItemLabelGenerator());
                logarithmicAxis = new ScalingLogarithmicAxis(this.getRangeTitle());
                logarithmicAxis.setStrictValuesFlag(false);
            } else {
                logarithmicAxis = new LogarithmicAxis(this.getRangeTitle());
                logarithmicAxis.setStrictValuesFlag(false);
            }
            plot.setRangeAxis((ValueAxis)logarithmicAxis);
        }
    }

    protected JFreeChart computeXYChart(XYDataset xyDataset) {
        return this.getChart(xyDataset);
    }

    protected void configureChart(JFreeChart chart) {
        Format formatter;
        NumberAxis numberAxis;
        ValueAxis rangeAxis;
        Format formatter2;
        NumberAxis numberAxis2;
        super.configureChart(chart);
        XYPlot plot = chart.getXYPlot();
        XYItemRenderer renderer = plot.getRenderer();
        if (!StringUtils.isEmpty((String)this.getTooltipFormula())) {
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)new FormulaXYZTooltipGenerator(this.getRuntime(), this.getTooltipFormula()));
        }
        if (!StringUtils.isEmpty((String)this.getUrlFormula())) {
            renderer.setURLGenerator((XYURLGenerator)new FormulaXYZURLGenerator(this.getRuntime(), this.getUrlFormula()));
        }
        renderer.setBaseItemLabelsVisible(Boolean.TRUE.equals(this.getItemsLabelVisible()));
        if (this.getItemLabelFont() != null) {
            renderer.setBaseItemLabelFont(this.getItemLabelFont());
        }
        plot.setOrientation(this.computePlotOrientation());
        ValueAxis domainAxis = plot.getDomainAxis();
        if (domainAxis instanceof NumberAxis) {
            numberAxis2 = (NumberAxis)domainAxis;
            numberAxis2.setAutoRangeIncludesZero(this.isDomainIncludesZero());
            numberAxis2.setAutoRangeStickyZero(this.isDomainStickyZero());
            if (this.getDomainPeriodCount() > 0.0) {
                if (this.getDomainTickFormat() != null) {
                    numberAxis2.setTickUnit(new NumberTickUnit(this.getDomainPeriodCount(), this.getDomainTickFormat()));
                } else if (this.getDomainTickFormatString() != null) {
                    formatter2 = new FastDecimalFormat(this.getDomainTickFormatString(), this.getResourceBundleFactory().getLocale());
                    numberAxis2.setTickUnit((NumberTickUnit)new FastNumberTickUnit(this.getDomainPeriodCount(), (FastDecimalFormat)formatter2));
                } else {
                    numberAxis2.setTickUnit((NumberTickUnit)new FastNumberTickUnit(this.getDomainPeriodCount()));
                }
            } else if (this.getDomainTickFormat() != null) {
                numberAxis2.setNumberFormatOverride(this.getDomainTickFormat());
            } else if (this.getDomainTickFormatString() != null) {
                formatter2 = new DecimalFormat(this.getDomainTickFormatString(), new DecimalFormatSymbols(this.getResourceBundleFactory().getLocale()));
                numberAxis2.setNumberFormatOverride((NumberFormat)formatter2);
            }
        } else if (domainAxis instanceof DateAxis) {
            numberAxis2 = (DateAxis)domainAxis;
            if (this.getDomainPeriodCount() > 0.0 && this.getDomainTimePeriod() != null) {
                if (this.getDomainTickFormatString() != null) {
                    formatter2 = new SimpleDateFormat(this.getDomainTickFormatString(), new DateFormatSymbols(this.getResourceBundleFactory().getLocale()));
                    numberAxis2.setTickUnit(new DateTickUnit(this.getDateUnitAsInt(this.getDomainTimePeriod()), (int)this.getDomainPeriodCount(), (DateFormat)formatter2));
                } else {
                    numberAxis2.setTickUnit(new DateTickUnit(this.getDateUnitAsInt(this.getDomainTimePeriod()), (int)this.getDomainPeriodCount()));
                }
            }
        }
        if (domainAxis != null) {
            int level;
            domainAxis.setLabel(this.getDomainTitle());
            if (this.getDomainTitleFont() != null) {
                domainAxis.setLabelFont(this.getDomainTitleFont());
            }
            domainAxis.setVerticalTickLabels(this.isDomainVerticalTickLabels());
            if (this.getDomainTickFont() != null) {
                domainAxis.setTickLabelFont(this.getDomainTickFont());
            }
            if (ClassicEngineBoot.isEnforceCompatibilityFor((int)(level = this.getRuntime().getProcessingContext().getCompatibilityLevel()), (int)3, (int)8, (int)99)) {
                if (this.getDomainMinimum() != 0.0) {
                    domainAxis.setLowerBound(this.getDomainMinimum());
                }
                if (this.getDomainMaximum() != 1.0) {
                    domainAxis.setUpperBound(this.getDomainMaximum());
                }
                if (this.getDomainMinimum() == 0.0 && this.getDomainMaximum() == 0.0) {
                    domainAxis.setLowerBound(0.0);
                    domainAxis.setUpperBound(1.0);
                    domainAxis.setAutoRange(true);
                }
            } else {
                domainAxis.setLowerBound(this.getDomainMinimum());
                domainAxis.setUpperBound(this.getDomainMaximum());
                domainAxis.setAutoRange(this.isDomainAxisAutoRange());
            }
        }
        if ((rangeAxis = plot.getRangeAxis()) instanceof NumberAxis) {
            numberAxis = (NumberAxis)rangeAxis;
            numberAxis.setAutoRangeIncludesZero(this.isRangeIncludesZero());
            numberAxis.setAutoRangeStickyZero(this.isRangeStickyZero());
            if (this.getRangePeriodCount() > 0.0) {
                if (this.getRangeTickFormat() != null) {
                    numberAxis.setTickUnit(new NumberTickUnit(this.getRangePeriodCount(), this.getRangeTickFormat()));
                } else if (this.getRangeTickFormatString() != null) {
                    formatter = new FastDecimalFormat(this.getRangeTickFormatString(), this.getResourceBundleFactory().getLocale());
                    numberAxis.setTickUnit((NumberTickUnit)new FastNumberTickUnit(this.getRangePeriodCount(), (FastDecimalFormat)formatter));
                } else {
                    numberAxis.setTickUnit((NumberTickUnit)new FastNumberTickUnit(this.getRangePeriodCount()));
                }
            } else if (this.getRangeTickFormat() != null) {
                numberAxis.setNumberFormatOverride(this.getRangeTickFormat());
            } else if (this.getRangeTickFormatString() != null) {
                formatter = new DecimalFormat(this.getRangeTickFormatString(), new DecimalFormatSymbols(this.getResourceBundleFactory().getLocale()));
                numberAxis.setNumberFormatOverride((NumberFormat)formatter);
            }
        } else if (rangeAxis instanceof DateAxis) {
            numberAxis = (DateAxis)rangeAxis;
            if (this.getRangePeriodCount() > 0.0 && this.getRangeTimePeriod() != null) {
                if (this.getRangeTickFormatString() != null) {
                    formatter = new SimpleDateFormat(this.getRangeTickFormatString(), new DateFormatSymbols(this.getResourceBundleFactory().getLocale()));
                    numberAxis.setTickUnit(new DateTickUnit(this.getDateUnitAsInt(this.getRangeTimePeriod()), (int)this.getRangePeriodCount(), (DateFormat)formatter));
                } else {
                    numberAxis.setTickUnit(new DateTickUnit(this.getDateUnitAsInt(this.getRangeTimePeriod()), (int)this.getRangePeriodCount()));
                }
            } else if (this.getRangeTickFormatString() != null) {
                formatter = new SimpleDateFormat(this.getRangeTickFormatString(), new DateFormatSymbols(this.getResourceBundleFactory().getLocale()));
                numberAxis.setDateFormatOverride((DateFormat)formatter);
            }
        }
        if (rangeAxis != null) {
            int level;
            rangeAxis.setLabel(this.getRangeTitle());
            if (this.getRangeTitleFont() != null) {
                rangeAxis.setLabelFont(this.getRangeTitleFont());
            }
            if (this.getRangeTickFont() != null) {
                rangeAxis.setTickLabelFont(this.getRangeTickFont());
            }
            if (ClassicEngineBoot.isEnforceCompatibilityFor((int)(level = this.getRuntime().getProcessingContext().getCompatibilityLevel()), (int)3, (int)8, (int)99)) {
                if (this.getRangeMinimum() != 0.0) {
                    rangeAxis.setLowerBound(this.getRangeMinimum());
                }
                if (this.getRangeMaximum() != 1.0) {
                    rangeAxis.setUpperBound(this.getRangeMaximum());
                }
                if (this.getRangeMinimum() == 0.0 && this.getRangeMaximum() == 0.0) {
                    rangeAxis.setLowerBound(0.0);
                    rangeAxis.setUpperBound(1.0);
                    rangeAxis.setAutoRange(true);
                }
            } else {
                rangeAxis.setLowerBound(this.getRangeMinimum());
                rangeAxis.setUpperBound(this.getRangeMaximum());
                rangeAxis.setAutoRange(this.isRangeAxisAutoRange());
            }
        }
        String[] colors = this.getSeriesColor();
        for (int i = 0; i < colors.length; ++i) {
            renderer.setSeriesPaint(i, (Paint)this.parseColorFromString(colors[i]));
        }
    }

    protected PlotOrientation computePlotOrientation() {
        PlotOrientation orientation = this.isHorizontal() ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        return orientation;
    }

    public List getSubtitles() {
        return Collections.emptyList();
    }

    public void addSubTitle(String subTitle) {
    }

    public JFreeChart getChart(XYDataset xyDataset) {
        return null;
    }

    public boolean isDisplayLabels() {
        return false;
    }

    public double getDomainPeriodCount() {
        return this.domainPeriodCount;
    }

    public void setDomainPeriodCount(double domainPeriodCount) {
        this.domainPeriodCount = domainPeriodCount;
    }

    public double getRangePeriodCount() {
        return this.rangePeriodCount;
    }

    public void setRangePeriodCount(double rangePeriodCount) {
        this.rangePeriodCount = rangePeriodCount;
    }

    private int getDateUnitAsInt(Class domainTimePeriod) {
        if (Second.class.equals((Object)domainTimePeriod)) {
            return 5;
        }
        if (Minute.class.equals((Object)domainTimePeriod)) {
            return 4;
        }
        if (Hour.class.equals((Object)domainTimePeriod)) {
            return 3;
        }
        if (Day.class.equals((Object)domainTimePeriod)) {
            return 2;
        }
        if (Month.class.equals((Object)domainTimePeriod)) {
            return 1;
        }
        if (Year.class.equals((Object)domainTimePeriod)) {
            return 0;
        }
        if (Second.class.equals((Object)domainTimePeriod)) {
            return 6;
        }
        return 2;
    }

    protected ExtTimeTableXYDataset convertToTable(XYDataset xyDataset) {
        TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)xyDataset;
        ExtTimeTableXYDataset tableXYDataset = new ExtTimeTableXYDataset();
        int count = timeSeriesCollection.getSeriesCount();
        for (int i = 0; i < count; ++i) {
            Comparable key = timeSeriesCollection.getSeriesKey(i);
            TimeSeries timeSeries = timeSeriesCollection.getSeries(i);
            int itemCount = timeSeries.getItemCount();
            for (int ic = 0; ic < itemCount; ++ic) {
                TimeSeriesDataItem seriesDataItem = timeSeries.getDataItem(ic);
                tableXYDataset.add((TimePeriod)seriesDataItem.getPeriod(), seriesDataItem.getValue(), key, false);
            }
        }
        return tableXYDataset;
    }

    protected TableXYDataset convertToTable(XYSeriesCollection xyDataset) {
        ExtCategoryTableXYDataset tableXYDataset = new ExtCategoryTableXYDataset();
        int count = xyDataset.getSeriesCount();
        for (int i = 0; i < count; ++i) {
            XYSeries timeSeries = xyDataset.getSeries(i);
            Comparable key = timeSeries.getKey();
            int itemCount = timeSeries.getItemCount();
            for (int ic = 0; ic < itemCount; ++ic) {
                XYDataItem seriesDataItem = timeSeries.getDataItem(ic);
                tableXYDataset.add(seriesDataItem.getX(), seriesDataItem.getY(), key, false);
            }
        }
        return tableXYDataset;
    }

    public void reconfigureForCompatibility(int versionTag) {
        if (ClassicEngineBoot.isEnforceCompatibilityFor((int)versionTag, (int)3, (int)8, (int)99)) {
            this.setRangeAxisAutoRange(this.getRangeMinimum() == 0.0 && this.getRangeMaximum() == 1.0);
            this.setDomainAxisAutoRange(this.getDomainMinimum() == 0.0 && this.getDomainMaximum() == 1.0);
        }
    }
}

