/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.pentaho.plugin.jfreereport.reportcharts.XYChartExpression;

public class XYLineChartExpression
extends XYChartExpression {
    private static final long serialVersionUID = 588996014868712814L;
    private String lineStyle;
    private float lineWidth = 1.0f;
    private boolean markersVisible;

    protected JFreeChart computeXYChart(XYDataset xyDataset) {
        JFreeChart chart;
        if (xyDataset instanceof TimeSeriesCollection) {
            chart = ChartFactory.createTimeSeriesChart((String)this.computeTitle(), (String)this.getDomainTitle(), (String)this.getRangeTitle(), (XYDataset)xyDataset, (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
        } else {
            PlotOrientation orientation = this.computePlotOrientation();
            chart = ChartFactory.createXYLineChart((String)this.computeTitle(), (String)this.getDomainTitle(), (String)this.getRangeTitle(), (XYDataset)xyDataset, (PlotOrientation)orientation, (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
        }
        this.configureLogarithmicAxis(chart.getXYPlot());
        return chart;
    }

    protected void configureChart(JFreeChart chart) {
        super.configureChart(chart);
        XYPlot xypl = chart.getXYPlot();
        XYItemRenderer renderer = xypl.getRenderer();
        renderer.setStroke(XYLineChartExpression.translateLineStyle(this.lineWidth, this.lineStyle));
        if (renderer instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer1 = (XYLineAndShapeRenderer)renderer;
            renderer1.setShapesVisible(this.isMarkersVisible());
            renderer1.setBaseShapesFilled(this.isMarkersVisible());
        }
    }

    public String getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(String value) {
        this.lineStyle = value;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float value) {
        this.lineWidth = value;
    }

    public boolean isMarkersVisible() {
        return this.markersVisible;
    }

    public void setMarkersVisible(boolean markersVisible) {
        this.markersVisible = markersVisible;
    }
}

