/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.data.general.Dataset;
import org.pentaho.plugin.jfreereport.reportcharts.ExtendedXYZDataset;
import org.pentaho.plugin.jfreereport.reportcharts.XYSeriesCollectorFunction;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;

public class XYZSeriesCollectorFunction
extends XYSeriesCollectorFunction {
    private static final long serialVersionUID = -3612902208762624893L;
    private ArrayList zValueColumns = new ArrayList();
    private double maxZValue = 1.0;

    public void reportInitialized(ReportEvent event) {
        this.maxZValue = 1.0;
        super.reportInitialized(event);
    }

    public void setzValueColumn(int index, String field) {
        if (this.zValueColumns.size() == index) {
            this.zValueColumns.add(field);
        } else {
            this.zValueColumns.set(index, field);
        }
    }

    public String getzValueColumn(int index) {
        return (String)this.zValueColumns.get(index);
    }

    public int getzValueColumnCount() {
        return this.zValueColumns.size();
    }

    public String[] getzValueColumn() {
        return this.zValueColumns.toArray(new String[this.zValueColumns.size()]);
    }

    public void setzValueColumn(String[] fields) {
        this.zValueColumns.clear();
        this.zValueColumns.addAll(Arrays.asList(fields));
    }

    public double getMaxZValue() {
        return this.maxZValue;
    }

    protected void buildDataset() {
        ExtendedXYZDataset xyzDataset = (ExtendedXYZDataset)((Object)this.getDatasourceValue());
        int maxIndex = Math.min(this.getSeriesNameCount(), this.getxValueColumnCount());
        DataRow dataRow = this.getDataRow();
        for (int i = 0; i < maxIndex; ++i) {
            Object tmp;
            String seriesName = this.getSeriesName(i);
            String xColumn = this.getxValueColumn(i);
            String yColumn = this.getyValueColumn(i);
            String zColumn = this.getzValueColumn(i);
            Object xValueObject = dataRow.get(xColumn);
            Object yValueObject = dataRow.get(yColumn);
            Object zValueObject = dataRow.get(zColumn);
            if (this.isSeriesColumn() && (tmp = dataRow.get(seriesName)) != null) {
                seriesName = tmp.toString();
            }
            if (!(xValueObject instanceof Number) || !(yValueObject instanceof Number) || !(zValueObject instanceof Number)) continue;
            Number xValue = (Number)xValueObject;
            Number yValue = (Number)yValueObject;
            Number zValue = (Number)zValueObject;
            if (zValue.doubleValue() > this.maxZValue) {
                this.maxZValue = zValue.doubleValue();
            }
            double[][] seriesValues = new double[3][1];
            seriesValues[0][0] = xValue.doubleValue();
            seriesValues[1][0] = yValue.doubleValue();
            seriesValues[2][0] = zValue.doubleValue();
            xyzDataset.addSeries((Comparable)((Object)seriesName), seriesValues);
            xyzDataset.setMaxZValue(this.maxZValue);
        }
    }

    public Dataset createNewDataset() {
        this.maxZValue = 1.0;
        return new ExtendedXYZDataset();
    }

    public Expression getInstance() {
        XYZSeriesCollectorFunction fn = (XYZSeriesCollectorFunction)super.getInstance();
        fn.zValueColumns = (ArrayList)this.zValueColumns.clone();
        fn.maxZValue = 1.0;
        return fn;
    }
}

