/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts.collectors;

import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.pentaho.plugin.jfreereport.reportcharts.collectors.AbstractCollectorFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;

public class IntervalXYSeriesCollector
extends AbstractCollectorFunction {
    private ArrayList xMinValueColumns = new ArrayList();
    private ArrayList yMinValueColumns = new ArrayList();
    private ArrayList xMaxValueColumns = new ArrayList();
    private ArrayList yMaxValueColumns = new ArrayList();

    protected Dataset createNewDataset() {
        return new XYIntervalSeriesCollection();
    }

    public void setxMinValueColumn(int index, String field) {
        if (this.xMinValueColumns.size() == index) {
            this.xMinValueColumns.add(field);
        } else {
            this.xMinValueColumns.set(index, field);
        }
    }

    public String getxMinValueColumn(int index) {
        return (String)this.xMinValueColumns.get(index);
    }

    public int getxMinValueColumnCount() {
        return this.xMinValueColumns.size();
    }

    public String[] getxMinValueColumn() {
        return this.xMinValueColumns.toArray(new String[this.xMinValueColumns.size()]);
    }

    public void setxMinValueColumn(String[] fields) {
        this.xMinValueColumns.clear();
        this.xMinValueColumns.addAll(Arrays.asList(fields));
    }

    public void setyMinValueColumn(int index, String field) {
        if (this.yMinValueColumns.size() == index) {
            this.yMinValueColumns.add(field);
        } else {
            this.yMinValueColumns.set(index, field);
        }
    }

    public String getyMinValueColumn(int index) {
        return (String)this.yMinValueColumns.get(index);
    }

    public int getyMinValueColumnCount() {
        return this.yMinValueColumns.size();
    }

    public String[] getyMinValueColumn() {
        return this.yMinValueColumns.toArray(new String[this.yMinValueColumns.size()]);
    }

    public void setyMinValueColumn(String[] fields) {
        this.yMinValueColumns.clear();
        this.yMinValueColumns.addAll(Arrays.asList(fields));
    }

    public void setxMaxValueColumn(int index, String field) {
        if (this.xMaxValueColumns.size() == index) {
            this.xMaxValueColumns.add(field);
        } else {
            this.xMaxValueColumns.set(index, field);
        }
    }

    public String getxMaxValueColumn(int index) {
        return (String)this.xMaxValueColumns.get(index);
    }

    public int getxMaxValueColumnCount() {
        return this.xMaxValueColumns.size();
    }

    public String[] getxMaxValueColumn() {
        return this.xMaxValueColumns.toArray(new String[this.xMaxValueColumns.size()]);
    }

    public void setxMaxValueColumn(String[] fields) {
        this.xMaxValueColumns.clear();
        this.xMaxValueColumns.addAll(Arrays.asList(fields));
    }

    public String getyMaxValueColumn(int index) {
        return (String)this.yMaxValueColumns.get(index);
    }

    public int getyMaxValueColumnCount() {
        return this.yMaxValueColumns.size();
    }

    public String[] getyMaxValueColumn() {
        return this.yMaxValueColumns.toArray(new String[this.yMaxValueColumns.size()]);
    }

    public void setyMaxValueColumn(String[] fields) {
        this.yMaxValueColumns.clear();
        this.yMaxValueColumns.addAll(Arrays.asList(fields));
    }

    public Expression getInstance() {
        IntervalXYSeriesCollector expression = (IntervalXYSeriesCollector)super.getInstance();
        expression.xMinValueColumns = (ArrayList)this.xMinValueColumns.clone();
        expression.yMinValueColumns = (ArrayList)this.yMinValueColumns.clone();
        expression.xMaxValueColumns = (ArrayList)this.xMaxValueColumns.clone();
        expression.yMaxValueColumns = (ArrayList)this.yMaxValueColumns.clone();
        return expression;
    }

    protected void buildDataset() {
        XYIntervalSeriesCollection xyIntervalxySeriesDataset = (XYIntervalSeriesCollection)this.getDataSet();
        int maxIndex = Math.min(this.yMaxValueColumns.size(), Math.min(this.xMinValueColumns.size(), Math.min(this.yMinValueColumns.size(), this.xMaxValueColumns.size())));
        for (int i = 0; i < maxIndex; ++i) {
            XYIntervalSeries l_xyIntervalSeries;
            Number yMaxValue;
            Comparable seriesName = this.querySeriesValue(i);
            Object xValueObject = this.getDataRow().get((String)this.xMinValueColumns.get(i));
            Object yValueObject = this.getDataRow().get((String)this.yMinValueColumns.get(i));
            Object xMaxValueObject = this.getDataRow().get((String)this.xMaxValueColumns.get(i));
            Object yMaxValueObject = this.getDataRow().get((String)this.yMaxValueColumns.get(i));
            Number xValue = xValueObject instanceof Number ? (Number)((Number)xValueObject) : (Number)null;
            Number yValue = yValueObject instanceof Number ? (Number)((Number)yValueObject) : (Number)null;
            Number xMaxValue = xMaxValueObject instanceof Number ? (Number)((Number)xMaxValueObject) : (Number)null;
            Number number = yMaxValue = yMaxValueObject instanceof Number ? (Number)((Number)yMaxValueObject) : (Number)null;
            if (xValue == null || yValue == null || xMaxValue == null || yMaxValue == null) continue;
            int index = xyIntervalxySeriesDataset.indexOf(seriesName);
            if (index == -1) {
                l_xyIntervalSeries = new XYIntervalSeries(seriesName);
                xyIntervalxySeriesDataset.addSeries(l_xyIntervalSeries);
            } else {
                l_xyIntervalSeries = xyIntervalxySeriesDataset.getSeries(index);
            }
            l_xyIntervalSeries.add(xValue.doubleValue(), xValue.doubleValue(), xMaxValue.doubleValue(), yValue.doubleValue(), yValue.doubleValue(), yMaxValue.doubleValue());
        }
    }
}

