/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts.collectors;

import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.pentaho.plugin.jfreereport.reportcharts.collectors.AbstractCollectorFunction;
import org.pentaho.plugin.jfreereport.reportcharts.collectors.CollectorFunctionUtil;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.function.Expression;

public class PivotCategorySetCollector
extends AbstractCollectorFunction {
    private ArrayList valueColumns = new ArrayList();
    private String categoryColumn;

    public String getCategoryColumn() {
        return this.categoryColumn;
    }

    public void setCategoryColumn(String categoryColumn) {
        this.categoryColumn = categoryColumn;
    }

    public void setValueColumn(int index, String field) {
        if (this.valueColumns.size() == index) {
            this.valueColumns.add(field);
        } else {
            this.valueColumns.set(index, field);
        }
    }

    public String getValueColumn(int index) {
        return (String)this.valueColumns.get(index);
    }

    public int getValueColumnCount() {
        return this.valueColumns.size();
    }

    public String[] getValueColumn() {
        return this.valueColumns.toArray(new String[this.valueColumns.size()]);
    }

    public void setValueColumn(String[] fields) {
        this.valueColumns.clear();
        this.valueColumns.addAll(Arrays.asList(fields));
    }

    protected Dataset createNewDataset() {
        return new DefaultCategoryDataset();
    }

    protected void buildDataset() {
        DataRow dataRow = this.getDataRow();
        Object categoryObject = dataRow.get(this.getCategoryColumn());
        if (!(categoryObject instanceof Comparable)) {
            return;
        }
        Comparable categoryComparable = (Comparable)categoryObject;
        DefaultCategoryDataset categoryDataset = (DefaultCategoryDataset)this.getDataSet();
        int maxIndex = this.valueColumns.size();
        for (int i = 0; i < maxIndex; ++i) {
            Comparable seriesName = this.querySeriesValue(i);
            Object valueObject = dataRow.get(this.getValueColumn(i));
            Number value = valueObject instanceof Number ? (Number)((Number)valueObject) : (Number)null;
            Number existingValue = CollectorFunctionUtil.queryExistingValueFromDataSet((CategoryDataset)categoryDataset, categoryComparable, seriesName);
            if (existingValue != null) {
                if (value == null) continue;
                categoryDataset.setValue((Number)CollectorFunctionUtil.add(existingValue, value), categoryComparable, seriesName);
                continue;
            }
            categoryDataset.setValue(value, categoryComparable, seriesName);
        }
    }

    public Expression getInstance() {
        PivotCategorySetCollector expression = (PivotCategorySetCollector)super.getInstance();
        expression.valueColumns = (ArrayList)this.valueColumns.clone();
        return expression;
    }
}

