/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts.collectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.pentaho.plugin.jfreereport.reportcharts.collectors.AbstractCollectorFunction;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;

public class XYSeriesCollector
extends AbstractCollectorFunction {
    private ArrayList xValueColumns = new ArrayList();
    private ArrayList yValueColumns = new ArrayList();
    private transient HashMap seriesMap;

    protected Dataset createNewDataset() {
        this.seriesMap = new HashMap();
        return new XYSeriesCollection();
    }

    public void setXValueColumn(int index, String field) {
        if (this.xValueColumns.size() == index) {
            this.xValueColumns.add(field);
        } else {
            this.xValueColumns.set(index, field);
        }
    }

    public String getXValueColumn(int index) {
        return (String)this.xValueColumns.get(index);
    }

    public int getXValueColumnCount() {
        return this.xValueColumns.size();
    }

    public String[] getXValueColumn() {
        return this.xValueColumns.toArray(new String[this.xValueColumns.size()]);
    }

    public void setXValueColumn(String[] fields) {
        this.xValueColumns.clear();
        this.xValueColumns.addAll(Arrays.asList(fields));
    }

    public void setYValueColumn(int index, String field) {
        if (this.yValueColumns.size() == index) {
            this.yValueColumns.add(field);
        } else {
            this.yValueColumns.set(index, field);
        }
    }

    public String getYValueColumn(int index) {
        return (String)this.yValueColumns.get(index);
    }

    public int getYValueColumnCount() {
        return this.yValueColumns.size();
    }

    public String[] getYValueColumn() {
        return this.yValueColumns.toArray(new String[this.yValueColumns.size()]);
    }

    public void setYValueColumn(String[] fields) {
        this.yValueColumns.clear();
        this.yValueColumns.addAll(Arrays.asList(fields));
    }

    public Expression getInstance() {
        XYSeriesCollector expression = (XYSeriesCollector)super.getInstance();
        expression.xValueColumns = (ArrayList)this.xValueColumns.clone();
        expression.yValueColumns = (ArrayList)this.yValueColumns.clone();
        expression.seriesMap = null;
        return expression;
    }

    protected void buildDataset() {
        int i;
        XYSeriesCollection xySeriesDataset = (XYSeriesCollection)this.getDataSet();
        List seriesList = xySeriesDataset.getSeries();
        if (this.seriesMap == null) {
            HashMap<Comparable, XYSeries> seriesMap = new HashMap<Comparable, XYSeries>();
            for (i = 0; i < seriesList.size(); ++i) {
                XYSeries series = (XYSeries)seriesList.get(i);
                seriesMap.put(series.getKey(), series);
            }
            this.seriesMap = seriesMap;
        }
        int maxIndex = Math.min(this.xValueColumns.size(), this.yValueColumns.size());
        for (i = 0; i < maxIndex; ++i) {
            Comparable seriesName = this.querySeriesValue(i);
            Object xValueObject = this.getDataRow().get((String)this.xValueColumns.get(i));
            Object yValueObject = this.getDataRow().get((String)this.yValueColumns.get(i));
            if (!(xValueObject instanceof Number)) continue;
            Number xValue = (Number)xValueObject;
            Number yValue = yValueObject instanceof Number ? (Number)((Number)yValueObject) : (Number)null;
            XYSeries series = (XYSeries)this.seriesMap.get(seriesName);
            if (series == null) {
                series = new XYSeries(seriesName);
                xySeriesDataset.addSeries(series);
                this.seriesMap.put(seriesName, series);
            }
            series.add(xValue, yValue, false);
        }
    }

    public void reportDone(ReportEvent event) {
        this.seriesMap = null;
    }
}

