/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.legacy.charts.propertyeditor;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.libraries.designtime.swing.BasicFontPropertiesPane;

public class FontStringPropertyEditor
implements PropertyEditor {
    private String value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private BasicFontPropertiesPane basicFontPropertiesPane;

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setValue(Object value) {
        String oldValue = this.value;
        this.value = value instanceof String ? (String)value : null;
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String getAsText() {
        return this.value;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        if (this.basicFontPropertiesPane == null) {
            this.basicFontPropertiesPane = new BasicFontPropertiesPane();
            this.basicFontPropertiesPane.setExtendedFontPropertiesShowing(false);
            this.basicFontPropertiesPane.init();
            this.basicFontPropertiesPane.addChangeListener((ChangeListener)new FontPropertiesHandler());
        }
        if (this.value != null) {
            Font font = Font.decode(this.value);
            this.basicFontPropertiesPane.setFontFamily(font.getFamily());
            this.basicFontPropertiesPane.setFontStyle(font.getStyle());
            this.basicFontPropertiesPane.setFontSize(font.getSize());
        }
        return this.basicFontPropertiesPane;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    private class FontPropertiesHandler
    implements ChangeListener {
        private FontPropertiesHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            String fontName = FontStringPropertyEditor.this.basicFontPropertiesPane.getFontFamily();
            int fontSize = FontStringPropertyEditor.this.basicFontPropertiesPane.getFontSize();
            int fontStyle = FontStringPropertyEditor.this.basicFontPropertiesPane.getFontStyle();
            String fontStyleText = (fontStyle & 3) == 3 ? "BOLDITALIC" : ((fontStyle & 1) == 1 ? "BOLD" : ((fontStyle & 2) == 2 ? "ITALIC" : "PLAIN"));
            FontStringPropertyEditor.this.setValue(fontName + "-" + fontStyleText + "-" + fontSize);
        }
    }
}

