/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.legacy.charts.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class ItemLabelPrintedPropertyEditor
implements PropertyEditor {
    private Boolean value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public void setValue(Object value) {
        if (value == null || value instanceof Boolean) {
            Boolean oldValue = this.value;
            this.value = (Boolean)value;
            this.propertyChangeSupport.firePropertyChange(null, oldValue, value);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String getAsText() {
        if (this.value == null) {
            return "(default)";
        }
        if (Boolean.TRUE.equals(this.value)) {
            return "Show Labels";
        }
        if (Boolean.FALSE.equals(this.value)) {
            return "Hide Labels";
        }
        return null;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)text)) {
            this.setValue(null);
        } else if ("(default)".equals(text)) {
            this.setValue(null);
        } else if ("Show Labels".equals(text)) {
            this.setValue(Boolean.TRUE);
        } else if ("Hide Labels".equals(text)) {
            this.setValue(Boolean.FALSE);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public String[] getTags() {
        return new String[]{"(default)", "Show Labels", "Hide Labels"};
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

