/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.browser.MozillaDelegate;
import org.eclipse.swt.browser.SimpleEnumerator;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIDirectoryServiceProvider;
import org.eclipse.swt.internal.mozilla.nsIDirectoryServiceProvider2;
import org.eclipse.swt.internal.mozilla.nsIFile;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsISupports;

class AppFileLocProvider {
    XPCOMObject supports;
    XPCOMObject directoryServiceProvider;
    XPCOMObject directoryServiceProvider2;
    int refCount = 0;
    String mozillaPath;
    String profilePath;
    String[] pluginDirs;
    static final String SEPARATOR_OS = System.getProperty("file.separator");
    static final String CHROME_DIR = "chrome";
    static final String COMPONENTS_DIR = "components";
    static final String HISTORY_FILE = "history.dat";
    static final String LOCALSTORE_FILE = "localstore.rdf";
    static final String MIMETYPES_FILE = "mimeTypes.rdf";
    static final String PLUGINS_DIR = "plugins";
    static final String USER_PLUGINS_DIR = ".mozilla" + SEPARATOR_OS + "plugins";
    static final String PREFERENCES_FILE = "prefs.js";

    public AppFileLocProvider(String string) {
        this.mozillaPath = String.valueOf(string) + SEPARATOR_OS;
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.supports = new XPCOMObject(nArray){

            public int method0(int[] nArray) {
                return AppFileLocProvider.this.queryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return AppFileLocProvider.this.AddRef();
            }

            public int method2(int[] nArray) {
                return AppFileLocProvider.this.Release();
            }
        };
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        nArray2[3] = 3;
        this.directoryServiceProvider = new XPCOMObject(nArray2){

            public int method0(int[] nArray) {
                return AppFileLocProvider.this.queryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return AppFileLocProvider.this.AddRef();
            }

            public int method2(int[] nArray) {
                return AppFileLocProvider.this.Release();
            }

            public int method3(int[] nArray) {
                return AppFileLocProvider.this.getFile(nArray[0], nArray[1], nArray[2]);
            }
        };
        int[] nArray3 = new int[5];
        nArray3[0] = 2;
        nArray3[3] = 3;
        nArray3[4] = 2;
        this.directoryServiceProvider2 = new XPCOMObject(nArray3){

            public int method0(int[] nArray) {
                return AppFileLocProvider.this.queryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return AppFileLocProvider.this.AddRef();
            }

            public int method2(int[] nArray) {
                return AppFileLocProvider.this.Release();
            }

            public int method3(int[] nArray) {
                return AppFileLocProvider.this.getFile(nArray[0], nArray[1], nArray[2]);
            }

            public int method4(int[] nArray) {
                return AppFileLocProvider.this.getFiles(nArray[0], nArray[1]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.directoryServiceProvider != null) {
            this.directoryServiceProvider.dispose();
            this.directoryServiceProvider = null;
        }
        if (this.directoryServiceProvider2 != null) {
            this.directoryServiceProvider2.dispose();
            this.directoryServiceProvider2 = null;
        }
    }

    int getAddress() {
        return this.directoryServiceProvider.getAddress();
    }

    int queryInterface(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return -2147467262;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, n, 16);
        if (nsID2.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(n2, new int[]{this.supports.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(nsIDirectoryServiceProvider.NS_IDIRECTORYSERVICEPROVIDER_IID)) {
            XPCOM.memmove(n2, new int[]{this.directoryServiceProvider.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(nsIDirectoryServiceProvider2.NS_IDIRECTORYSERVICEPROVIDER2_IID)) {
            XPCOM.memmove(n2, new int[]{this.directoryServiceProvider2.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(n2, new int[1], C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    void setProfilePath(String string) {
        this.profilePath = string;
    }

    int getFiles(int n, int n2) {
        Object object;
        int n3;
        int n4 = XPCOM.strlen(n);
        byte[] byArray = new byte[n4];
        XPCOM.memmove(byArray, n, n4);
        String string = new String(MozillaDelegate.mbcsToWcs(null, byArray));
        String[] stringArray = null;
        if (string.equals("APluginsDL")) {
            if (this.pluginDirs == null) {
                int n5 = 0;
                int n6 = C.getenv(MozillaDelegate.wcsToMbcs(null, "MOZ_PLUGIN_PATH", true));
                if (n6 != 0) {
                    n3 = C.strlen(n6);
                    object = new byte[n3];
                    C.memmove((byte[])object, n6, n3);
                    String string2 = new String(MozillaDelegate.mbcsToWcs(null, (byte[])object));
                    if (string2.length() > 0) {
                        this.pluginDirs = new String[3];
                        this.pluginDirs[n5++] = string2;
                    }
                }
                if (this.pluginDirs == null) {
                    this.pluginDirs = new String[2];
                }
                this.pluginDirs[n5++] = String.valueOf(this.mozillaPath) + PLUGINS_DIR;
                this.pluginDirs[n5++] = String.valueOf(System.getProperty("user.home")) + SEPARATOR_OS + USER_PLUGINS_DIR;
            }
            stringArray = this.pluginDirs;
        }
        XPCOM.memmove(n2, new int[1], C.PTR_SIZEOF);
        if (stringArray != null) {
            int[] nArray = new int[1];
            nsISupports[] nsISupportsArray = new nsISupports[stringArray.length];
            n3 = 0;
            while (n3 < stringArray.length) {
                object = new nsEmbedString(stringArray[n3]);
                int n7 = XPCOM.NS_NewLocalFile(((nsEmbedString)object).getAddress(), true, nArray);
                if (n7 != 0) {
                    Mozilla.error(n7);
                }
                if (nArray[0] == 0) {
                    Mozilla.error(-2147467261);
                }
                ((nsEmbedString)object).dispose();
                nsILocalFile nsILocalFile2 = new nsILocalFile(nArray[0]);
                nArray[0] = 0;
                n7 = nsILocalFile2.QueryInterface(nsIFile.NS_IFILE_IID, nArray);
                if (n7 != 0) {
                    Mozilla.error(n7);
                }
                if (nArray[0] == 0) {
                    Mozilla.error(-2147467261);
                }
                nsILocalFile2.Release();
                nsIFile nsIFile2 = new nsIFile(nArray[0]);
                nArray[0] = 0;
                nsISupportsArray[n3] = nsIFile2;
                ++n3;
            }
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator(nsISupportsArray);
            simpleEnumerator.AddRef();
            XPCOM.memmove(n2, new int[]{simpleEnumerator.getAddress()}, C.PTR_SIZEOF);
            return 0;
        }
        return -2147467259;
    }

    int getFile(int n, int n2, int n3) {
        int n4 = XPCOM.strlen(n);
        byte[] byArray = new byte[n4];
        XPCOM.memmove(byArray, n, n4);
        String string = new String(MozillaDelegate.mbcsToWcs(null, byArray));
        String string2 = null;
        if (string.equals("UHist")) {
            string2 = String.valueOf(this.profilePath) + HISTORY_FILE;
        } else if (string.equals("UMimTyp")) {
            string2 = String.valueOf(this.profilePath) + MIMETYPES_FILE;
        } else if (string.equals("PrefF")) {
            string2 = String.valueOf(this.profilePath) + PREFERENCES_FILE;
        } else if (string.equals("PrefD")) {
            string2 = this.profilePath;
        } else if (string.equals("UChrm")) {
            string2 = String.valueOf(this.profilePath) + CHROME_DIR;
        } else if (string.equals("ProfD")) {
            string2 = this.profilePath;
        } else if (string.equals("LclSt")) {
            string2 = String.valueOf(this.profilePath) + LOCALSTORE_FILE;
        } else if (string.equals("cachePDir")) {
            string2 = this.profilePath;
        } else if (string.equals("Home")) {
            string2 = System.getProperty("user.home");
        } else if (string.equals("TmpD")) {
            string2 = System.getProperty("java.io.tmpdir");
        } else if (string.equals("GreD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("GreComsD")) {
            string2 = String.valueOf(this.mozillaPath) + COMPONENTS_DIR;
        } else if (string.equals("MozBinD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("CurProcD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("ComsD")) {
            string2 = String.valueOf(this.mozillaPath) + COMPONENTS_DIR;
        } else if (string.equals("XCurProcD")) {
            string2 = this.mozillaPath;
        }
        XPCOM.memmove(n2, new int[]{1}, 4);
        XPCOM.memmove(n3, new int[1], C.PTR_SIZEOF);
        if (string2 != null && string2.length() > 0) {
            int[] nArray = new int[1];
            nsEmbedString nsEmbedString2 = new nsEmbedString(string2);
            int n5 = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), true, nArray);
            if (n5 != 0) {
                Mozilla.error(n5);
            }
            if (nArray[0] == 0) {
                Mozilla.error(-2147467261);
            }
            nsEmbedString2.dispose();
            nsILocalFile nsILocalFile2 = new nsILocalFile(nArray[0]);
            nArray[0] = 0;
            n5 = nsILocalFile2.QueryInterface(nsIFile.NS_IFILE_IID, nArray);
            if (n5 != 0) {
                Mozilla.error(n5);
            }
            if (nArray[0] == 0) {
                Mozilla.error(-2147467261);
            }
            XPCOM.memmove(n3, new int[]{nArray[0]}, C.PTR_SIZEOF);
            nsILocalFile2.Release();
            return 0;
        }
        return -2147467259;
    }
}

